/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.item;

import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.jetbrains.annotations.Nullable;

public class GatePearlItem
extends Item
implements ITabFiller {
    public GatePearlItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        ItemStack stack = ctx.getItemInHand();
        BlockPos pos = ctx.getClickedPos();
        DynamicHolder<Gateway> gate = GatePearlItem.getGate(stack);
        if (!gate.isBound()) {
            return InteractionResult.FAIL;
        }
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        GatewayEntity entity = ((Gateway)gate.get()).createEntity(world, ctx.getPlayer());
        BlockState state = world.getBlockState(pos);
        VoxelShape shape = state.getCollisionShape((BlockGetter)world, pos);
        entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + (shape.isEmpty() ? 0.0 : shape.max(Direction.Axis.Y)), (double)pos.getZ() + 0.5);
        double spacing = Math.max(0.0, ((Gateway)gate.get()).rules().spacing());
        if (!world.getEntitiesOfClass(GatewayEntity.class, entity.getBoundingBox().inflate(spacing)).isEmpty()) {
            return InteractionResult.FAIL;
        }
        int y = 0;
        while (y++ < 4 && !world.noCollision((Entity)entity)) {
            entity.setPos(entity.getX(), entity.getY() + 1.0, entity.getZ());
        }
        if (!world.noCollision((Entity)entity)) {
            ctx.getPlayer().sendSystemMessage((Component)Component.translatable((String)"error.gateways.no_space").withStyle(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        world.addFreshEntity((Entity)entity);
        entity.onGateCreated();
        if (!ctx.getPlayer().isCreative()) {
            stack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public static void setGate(ItemStack opener, Gateway gate) {
        GatePearlItem.setGate(opener, (DynamicHolder<Gateway>)GatewayRegistry.INSTANCE.holder(gate));
    }

    public static void setGate(ItemStack opener, DynamicHolder<Gateway> gate) {
        opener.set(GatewayObjects.GATEWAY_COMPONENT, gate);
    }

    public static DynamicHolder<Gateway> getGate(ItemStack opener) {
        return (DynamicHolder)opener.getOrDefault(GatewayObjects.GATEWAY_COMPONENT, (Object)GatewayRegistry.INSTANCE.emptyHolder());
    }

    public Component getName(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            return super.getName(stack);
        }
        DynamicHolder<Gateway> gate = GatePearlItem.getGate(stack);
        if (gate.isBound()) {
            return Component.translatable((String)"gateways.gate_pearl", (Object[])new Object[]{Component.translatable((String)gate.getId().toString().replace(':', '.'))}).withStyle(Style.EMPTY.withColor(((Gateway)gate.get()).color()));
        }
        return super.getName(stack);
    }

    public void fillItemCategory(CreativeModeTab group, BuildCreativeModeTabContentsEvent event) {
        GatePearlItem.generateGatePearlStacks(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        DynamicHolder<Gateway> holder = GatePearlItem.getGate(stack);
        if (!holder.isBound()) {
            tooltip.add((Component)Component.literal((String)"Errored Gate Pearl, file a bug report detailing how you obtained this."));
        } else if (FMLEnvironment.dist.isClient()) {
            ((Gateway)holder.get()).appendPearlTooltip(ctx, tooltip, flag);
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        DynamicHolder<Gateway> gate = GatePearlItem.getGate(stack);
        if (gate.isBound()) {
            return gate.getId().getNamespace();
        }
        return super.getCreatorModId(stack);
    }

    public static void generateGatePearlStacks(Consumer<ItemStack> output) {
        GatewayRegistry.INSTANCE.getValues().stream().sorted(Comparator.comparing(Gateway::size).thenComparing(arg_0 -> ((GatewayRegistry)GatewayRegistry.INSTANCE).getKey(arg_0))).forEach(gate -> {
            ItemStack stack = new ItemStack(GatewayObjects.GATE_PEARL);
            GatePearlItem.setGate(stack, gate);
            output.accept(stack);
        });
    }
}

