/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.systems.gear.GearSet;
import dev.shadowsoffire.placebo.systems.gear.GearSetRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;

public interface WaveModifier
extends CodecProvider<WaveModifier> {
    public static final CodecMap<WaveModifier> CODEC = new CodecMap("Gateway Wave Modifier");

    public void apply(LivingEntity var1);

    public void appendHoverText(Item.TooltipContext var1, Consumer<MutableComponent> var2);

    public static void initSerializers() {
        WaveModifier.register("mob_effect", EffectModifier.CODEC);
        WaveModifier.register("attribute", AttributeModifier.CODEC);
        WaveModifier.register("gear_set", GearSetModifier.CODEC);
        CODEC.setDefaultCodec(AttributeModifier.CODEC);
    }

    private static void register(String id, Codec<? extends WaveModifier> codec) {
        CODEC.register(Gateways.loc(id), codec);
    }

    public record EffectModifier(ChancedEffectInstance effect) implements WaveModifier
    {
        public static Codec<EffectModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ChancedEffectInstance.CONSTANT_CODEC.fieldOf("effect").forGetter(EffectModifier::effect)).apply((Applicative)inst, EffectModifier::new));

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity) {
            int duration = entity instanceof Creeper ? 6000 : Integer.MAX_VALUE;
            entity.addEffect(this.effect.createDeterministic(duration));
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            ArrayList output = new ArrayList();
            PotionContents.addPotionTooltip(Arrays.asList(this.effect.createDeterministic(1)), output::add, (float)1.0f, (float)ctx.tickRate());
            list.accept(Component.literal((String)((Component)output.get(0)).getString()));
        }
    }

    public record AttributeModifier(RandomAttributeModifier modifier) implements WaveModifier
    {
        public static Codec<AttributeModifier> CODEC = RandomAttributeModifier.CONSTANT_CODEC.xmap(AttributeModifier::new, AttributeModifier::modifier);

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity) {
            AttributeInstance inst = entity.getAttribute(this.modifier.attribute());
            if (inst == null) {
                return;
            }
            inst.addPermanentModifier(this.modifier.createDeterministic(Gateways.loc("gateway_random_modifier_" + entity.getRandom().nextInt())));
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(((Attribute)this.modifier.attribute().value()).toComponent(this.modifier.createDeterministic(Gateways.loc("gateway_random_modifier")), ApothicAttributes.getTooltipFlag()));
        }
    }

    public record GearSetModifier(DynamicHolder<GearSet> set) implements WaveModifier
    {
        public static Codec<GearSetModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GearSetRegistry.INSTANCE.holderCodec().fieldOf("gear_set").forGetter(GearSetModifier::set)).apply((Applicative)inst, GearSetModifier::new));

        public Codec<? extends WaveModifier> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(LivingEntity entity) {
            ((GearSet)this.set.get()).apply(entity);
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"modifier.gateways.gear_set", (Object[])new Object[]{Component.translatable((String)this.set.getId().toLanguageKey("gear_set"))}));
        }
    }
}

