/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public interface Reward
extends CodecProvider<Reward> {
    public static final CodecMap<Reward> CODEC = new CodecMap("Gateway Reward");
    public static final Method dropFromLootTable = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"dropFromLootTable", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
    public static final MethodHandle DROP_LOOT = Reward.lootMethodHandle();

    public void generateLoot(ServerLevel var1, GatewayEntity var2, Player var3, Consumer<ItemStack> var4);

    public void appendHoverText(Item.TooltipContext var1, Consumer<MutableComponent> var2);

    public static void initSerializers() {
        Reward.register("stack", StackReward.CODEC);
        Reward.register("stack_list", StackListReward.CODEC);
        Reward.register("entity_loot", EntityLootReward.CODEC);
        Reward.register("loot_table", LootTableReward.CODEC);
        Reward.register("chanced", ChancedReward.CODEC);
        Reward.register("command", CommandReward.CODEC);
        Reward.register("experience", XpReward.CODEC);
        Reward.register("summon", SummonReward.CODEC);
    }

    private static void register(String id, Codec<? extends Reward> codec) {
        CODEC.register(Gateways.loc(id), codec);
    }

    private static MethodHandle lootMethodHandle() {
        dropFromLootTable.setAccessible(true);
        try {
            return MethodHandles.lookup().unreflect(dropFromLootTable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public record StackReward(ItemStack stack) implements Reward
    {
        public static Codec<StackReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.CODEC.fieldOf("stack").forGetter(StackReward::stack)).apply((Applicative)inst, StackReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            list.accept(this.stack.copy());
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"reward.gateways.stack", (Object[])new Object[]{this.stack.getCount(), this.stack.getHoverName()}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record StackListReward(List<ItemStack> stacks) implements Reward
    {
        public static Codec<StackListReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.CODEC.listOf().fieldOf("stacks").forGetter(StackListReward::stacks)).apply((Applicative)inst, StackListReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            this.stacks.forEach(s -> list.accept(s.copy()));
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            for (ItemStack stack : this.stacks) {
                list.accept(Component.translatable((String)"reward.gateways.stack", (Object[])new Object[]{stack.getCount(), stack.getHoverName()}));
            }
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record EntityLootReward(EntityType<?> type, @Nullable CompoundTag nbt, int rolls) implements Reward
    {
        public static Codec<EntityLootReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(EntityLootReward::type), (App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt").forGetter(r -> Optional.ofNullable(r.nbt)), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("rolls", (Object)1).forGetter(EntityLootReward::rolls)).apply((Applicative)inst, (type, nbt, rolls) -> new EntityLootReward((EntityType<?>)type, nbt.orElse(null), (int)rolls)));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            try {
                ArrayList items = new ArrayList();
                Entity entity = this.type.create((Level)level);
                entity.getPersistentData().putBoolean("apoth.no_pinata", true);
                for (int i = 0; i < this.rolls; ++i) {
                    if (this.nbt != null) {
                        entity.load(this.nbt);
                    }
                    entity.moveTo(summoner.getX(), summoner.getY(), summoner.getZ(), 0.0f, 0.0f);
                    DamageSource src = new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.GENERIC_KILL), (Entity)summoner);
                    entity.hurt(src, 1.0f);
                    entity.captureDrops(items);
                    DROP_LOOT.invoke(entity, level.damageSources().playerAttack(summoner), true);
                }
                entity.remove(Entity.RemovalReason.DISCARDED);
                items.stream().map(ItemEntity::getItem).forEach(list);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"reward.gateways.entity", (Object[])new Object[]{this.rolls, Component.translatable((String)this.type.getDescriptionId())}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record LootTableReward(ResourceLocation table, int rolls, String desc) implements Reward
    {
        public static Codec<LootTableReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(LootTableReward::table), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("rolls", (Object)1).forGetter(LootTableReward::rolls), (App)Codec.STRING.fieldOf("desc").forGetter(LootTableReward::desc)).apply((Applicative)inst, LootTableReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            LootTable realTable = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.table));
            for (int i = 0; i < this.rolls; ++i) {
                LootParams.Builder ctx = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)gate.getPosition(1.0f));
                ctx.withLuck(summoner.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)summoner).withParameter(LootContextParams.TOOL, (Object)summoner.getMainHandItem());
                realTable.getRandomItems(ctx.create(LootContextParamSets.CHEST)).forEach(list);
            }
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"reward.gateways.loot_table", (Object[])new Object[]{this.rolls, this.desc.isEmpty() ? this.table : Component.translatable((String)this.desc)}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record ChancedReward(Reward reward, float chance) implements Reward
    {
        public static Codec<ChancedReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("reward").forGetter(ChancedReward::reward), (App)Codec.FLOAT.fieldOf("chance").forGetter(ChancedReward::chance)).apply((Applicative)inst, ChancedReward::new));
        protected static final DecimalFormat fmt = new DecimalFormat("##.##%");

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            if (level.random.nextFloat() < this.chance) {
                this.reward.generateLoot(level, gate, summoner, list);
            }
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            this.reward.appendHoverText(ctx, c -> list.accept(Component.translatable((String)"reward.gateways.chance", (Object[])new Object[]{fmt.format(this.chance), c})));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record CommandReward(String command, String desc) implements Reward
    {
        public static Codec<CommandReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("command").forGetter(CommandReward::command), (App)Codec.STRING.fieldOf("desc").forGetter(CommandReward::desc)).apply((Applicative)inst, CommandReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            String realCmd = this.command.replace("<summoner>", summoner.getGameProfile().getName());
            level.getServer().getCommands().performPrefixedCommand(gate.createCommandSourceStack(), realCmd);
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)this.desc));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record XpReward(int xp, int orbSize) implements Reward
    {
        public static Codec<XpReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("experience").forGetter(XpReward::xp), (App)Codec.INT.optionalFieldOf("orb_size", (Object)5).forGetter(XpReward::orbSize)).apply((Applicative)inst, XpReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            for (int remaining = this.xp; remaining > 0; remaining -= this.orbSize) {
                level.addFreshEntity((Entity)new ExperienceOrb((Level)level, gate.getX(), gate.getY(), gate.getZ(), this.orbSize));
            }
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"reward.gateways.experience", (Object[])new Object[]{this.xp}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record SummonReward(WaveEntity entity) implements Reward
    {
        public static Codec<SummonReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WaveEntity.CODEC.fieldOf("entity").forGetter(SummonReward::entity)).apply((Applicative)inst, SummonReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            for (int i = 0; i < this.entity.getCount(); ++i) {
                LivingEntity ent = this.entity.createEntity(level, gate);
                if (ent == null) continue;
                Vec3 pos = gate.getGateway().spawnAlgo().spawn(level, gate.position(), gate, (Entity)ent);
                ent.setPos(pos != null ? pos : gate.position());
                level.addFreshEntity((Entity)ent);
            }
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"reward.gateways.summon", (Object[])new Object[]{this.entity.getDescription()}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }
}

