/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public record GateRules(double spawnRange, double leashRange, boolean allowDiscarding, boolean allowDimChange, boolean playerDamageOnly, boolean removeOnFailure, boolean failOnOutOfBounds, double spacing, double followRangeBoost, float defaultDropChance) {
    public static final DecimalFormat FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("#.#"), fmt -> fmt.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final Codec<GateRules> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.DOUBLE.optionalFieldOf("spawn_range", (Object)8.0).forGetter(GateRules::spawnRange), (App)Codec.DOUBLE.optionalFieldOf("leash_range", (Object)32.0).forGetter(GateRules::leashRange), (App)Codec.BOOL.optionalFieldOf("allow_discarding", (Object)false).forGetter(GateRules::allowDiscarding), (App)Codec.BOOL.optionalFieldOf("allow_dim_change", (Object)false).forGetter(GateRules::allowDimChange), (App)Codec.BOOL.optionalFieldOf("player_damage_only", (Object)false).forGetter(GateRules::playerDamageOnly), (App)Codec.BOOL.optionalFieldOf("remove_mobs_on_failure", (Object)true).forGetter(GateRules::removeOnFailure), (App)Codec.BOOL.optionalFieldOf("fail_on_out_of_bounds", (Object)false).forGetter(GateRules::failOnOutOfBounds), (App)Codec.DOUBLE.optionalFieldOf("spacing", (Object)0.0).forGetter(GateRules::spacing), (App)Codec.DOUBLE.optionalFieldOf("follow_range_boost", (Object)32.0).forGetter(GateRules::followRangeBoost), (App)Codec.FLOAT.optionalFieldOf("default_drop_chance", (Object)Float.valueOf(0.0f)).forGetter(GateRules::defaultDropChance)).apply((Applicative)inst, GateRules::new));
    public static final GateRules DEFAULT = (GateRules)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow()).getFirst();

    public List<MutableComponent> buildDeviations() {
        if (DEFAULT.equals(this)) {
            return Collections.emptyList();
        }
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        GateRules.append("spawn_range", list, this.spawnRange, GateRules.DEFAULT.spawnRange);
        GateRules.append("leash_range", list, this.leashRange, GateRules.DEFAULT.leashRange);
        GateRules.append("allow_discarding", list, this.allowDiscarding, GateRules.DEFAULT.allowDiscarding);
        GateRules.append("allow_dim_change", list, this.allowDimChange, GateRules.DEFAULT.allowDimChange);
        GateRules.append("player_damage_only", list, this.playerDamageOnly, GateRules.DEFAULT.playerDamageOnly);
        GateRules.append("remove_mobs_on_failure", list, this.removeOnFailure, GateRules.DEFAULT.removeOnFailure);
        GateRules.append("fail_on_out_of_bounds", list, this.failOnOutOfBounds, GateRules.DEFAULT.failOnOutOfBounds);
        GateRules.append("spacing", list, this.spacing, GateRules.DEFAULT.spacing);
        return list;
    }

    private static <T> void append(String name, List<MutableComponent> list, T val, T def) {
        if (!val.equals(def)) {
            MutableComponent comp = Component.translatable((String)("rule.gateways." + name), (Object[])new Object[]{GateRules.fmt(val).withStyle(ChatFormatting.GREEN)});
            comp.append(CommonComponents.SPACE);
            comp.append((Component)Component.translatable((String)"rule.gateways.default", (Object[])new Object[]{GateRules.fmt(def)}).withStyle(ChatFormatting.DARK_GRAY));
            list.add(comp);
        }
    }

    private static MutableComponent fmt(Object val) {
        if (val instanceof Number) {
            Number n = (Number)val;
            return Component.literal((String)FORMAT.format(n));
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            return Component.translatable((String)("tooltip.gateways." + (b != false ? "true" : "false")));
        }
        return Component.literal((String)("Unknown: " + String.valueOf(val)));
    }
}

