/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.compat;

import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.item.GatePearlItem;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class GatewayJEIPlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)GatewayObjects.GATE_PEARL.value(), (IIngredientSubtypeInterpreter)new GateOpenerSubtypes());
    }

    public void registerRecipes(IRecipeRegistration reg) {
        NonNullList list = NonNullList.create();
        GatePearlItem.generateGatePearlStacks(arg_0 -> list.add(arg_0));
        reg.addIngredientInfo((List)list, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"info.gateways.gate_pearl"), Component.translatable((String)"info.gateways.gate_pearl.2")});
    }

    public ResourceLocation getPluginUid() {
        return Gateways.loc("gateways");
    }

    private static class GateOpenerSubtypes
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private GateOpenerSubtypes() {
        }

        public String apply(ItemStack stack, UidContext context) {
            DynamicHolder<Gateway> holder = GatePearlItem.getGate(stack);
            if (holder.isBound()) {
                return holder.getId().toString();
            }
            return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        }
    }
}

