/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.shadowsoffire.gateways.client.GatewayParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GatewayParticle
extends TextureSheetParticle {
    static final ParticleRenderType RENDER_TYPE = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tess, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            return tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "GatewayParticleType";
        }
    };

    public GatewayParticle(GatewayParticleData data, ClientLevel level, double x, double y, double z, double velX, double velY, double velZ) {
        super(level, x, y, z, velX, velY, velZ);
        this.rCol = data.red();
        this.gCol = data.green();
        this.bCol = data.blue();
        this.lifetime = 40;
        this.xd = velX;
        this.yd = velY;
        this.zd = velZ;
    }

    protected int getLightColor(float partialTicks) {
        return LightTexture.pack((int)15, (int)15);
    }

    public ParticleRenderType getRenderType() {
        return RENDER_TYPE;
    }

    public float getQuadSize(float p_217561_1_) {
        return 0.75f * this.quadSize * Mth.clamp((float)(((float)this.age + p_217561_1_) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.alpha = 1.0f - (float)this.age / (float)this.lifetime;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= (double)0.86f;
            this.yd *= (double)0.86f;
            this.zd *= (double)0.86f;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }
}

