/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways;

import dev.shadowsoffire.gateways.GatewayEvents;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.endless.ApplicationMode;
import dev.shadowsoffire.gateways.payloads.ParticlePayload;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gateways")
public class Gateways {
    public static final String MODID = "gateways";
    public static final Logger LOGGER = LogManager.getLogger((String)"Gateways to Eternity");

    public Gateways(IEventBus bus) {
        bus.register((Object)this);
        PayloadHelper.registerPayload((PayloadProvider)new ParticlePayload.Provider());
        NeoForge.EVENT_BUS.register((Object)new GatewayEvents());
        GatewayObjects.bootstrap(bus);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        GatewayRegistry.INSTANCE.registerToBus();
        e.enqueueWork(() -> {
            WaveModifier.initSerializers();
            Reward.initSerializers();
            WaveEntity.initSerializers();
            Failure.initSerializers();
            ApplicationMode.initSerializers();
            TabFillingRegistry.register((ResourceKey)GatewayObjects.TAB.getKey(), (Holder[])new Holder[]{GatewayObjects.GATE_PEARL});
            Stats.CUSTOM.get((Object)((ResourceLocation)GatewayObjects.GATES_DEFEATED.value()), StatFormatter.DEFAULT);
        });
    }

    public static ResourceLocation loc(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)s);
    }
}

