/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDryingBasin;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

@GameTestHolder(value="integratedtunnels")
@PrefixGameTestTemplate(value=false)
public class GameTestsFluids {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testFluidImporterToInterfaceBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west());
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east());
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, "Basin out does not contain energy");
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, "Basin in was not drained");
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), "Importer is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.IMPORTER_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status is incorrect");
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, "Active aspect is incorrect");
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Fluid.BOOLEAN_IMPORT).isEmpty(), "Active aspect has errors");
        });
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testFluidInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.EXPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west());
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.Fluid.BOOLEAN_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east());
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, "Basin out does not contain energy");
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, "Basin in was not drained");
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), "Exporter is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.EXPORTER_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status is incorrect");
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Fluid.BOOLEAN_EXPORT, "Active aspect is incorrect");
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Fluid.BOOLEAN_EXPORT).isEmpty(), "Active aspect has errors");
        });
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testFluidImporterToInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().north(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west());
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectExporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.Fluid.BOOLEAN_EXPORT, (ItemStack)variableAspectExporter);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinInterface = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east());
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().north());
            helper.assertValueEqual((Object)basinInterface.getTank().getFluidAmount(), (Object)0, "Basin interface was not drained");
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, "Basin out does not contain energy");
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, "Basin in was not drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testFluidsImporterToInterfaceFluidCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west());
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 100)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.FLUIDSTACK_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east());
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, "Basin out does not contain energy");
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, "Basin in was not drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testFluidsImporterToInterfaceFluidIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west());
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 100)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.FLUIDSTACK_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east());
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)0, "Basin out was filled");
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)1000, "Basin in was drained");
        });
    }
}

