/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.jei;

import de.cech12.brickfurnace.Constants;
import de.cech12.brickfurnace.crafting.BrickBlastingRecipe;
import de.cech12.brickfurnace.crafting.BrickSmeltingRecipe;
import de.cech12.brickfurnace.crafting.BrickSmokingRecipe;
import de.cech12.brickfurnace.jei.BrickBlastingCategory;
import de.cech12.brickfurnace.jei.BrickSmeltingCategory;
import de.cech12.brickfurnace.jei.BrickSmokingCategory;
import de.cech12.brickfurnace.platform.Services;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class BrickFurnaceJEIPlugin
implements IModPlugin {
    private static BrickSmeltingCategory smeltingRecipeType;
    private static BrickSmokingCategory smokingRecipeType;
    private static BrickBlastingCategory blastingRecipeType;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return Constants.id("plugin_brickfurnace");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        smeltingRecipeType = new BrickSmeltingCategory(guiHelper);
        smokingRecipeType = new BrickSmokingCategory(guiHelper);
        blastingRecipeType = new BrickBlastingCategory(guiHelper);
        registration.addRecipeCategories(new IRecipeCategory[]{smeltingRecipeType, smokingRecipeType, blastingRecipeType});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            RecipeManager manager = player.connection.getRecipeManager();
            registration.addRecipes(smeltingRecipeType.getRecipeType(), manager.getAllRecipesFor(Constants.SMELTING_RECIPE_TYPE.get()));
            registration.addRecipes(smokingRecipeType.getRecipeType(), manager.getAllRecipesFor(Constants.SMOKING_RECIPE_TYPE.get()));
            registration.addRecipes(blastingRecipeType.getRecipeType(), manager.getAllRecipesFor(Constants.BLASTING_RECIPE_TYPE.get()));
            if (Services.CONFIG.areVanillaRecipesEnabled()) {
                registration.addRecipes(smeltingRecipeType.getRecipeType(), manager.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.SMELTING).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.id())).map(recipe -> new RecipeHolder(recipe.id(), (Recipe)BrickSmeltingRecipe.convert((SmeltingRecipe)recipe.value(), player.level().registryAccess()))).collect(Collectors.toList()));
                registration.addRecipes(smokingRecipeType.getRecipeType(), manager.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.SMOKING).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.id())).map(recipe -> new RecipeHolder(recipe.id(), (Recipe)BrickSmokingRecipe.convert((SmokingRecipe)recipe.value(), player.level().registryAccess()))).collect(Collectors.toList()));
                registration.addRecipes(blastingRecipeType.getRecipeType(), manager.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.BLASTING).stream().filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.id())).map(recipe -> new RecipeHolder(recipe.id(), (Recipe)BrickBlastingRecipe.convert((BlastingRecipe)recipe.value(), player.level().registryAccess()))).collect(Collectors.toList()));
            }
        }
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Constants.BRICK_FURNACE_BLOCK.get()), new RecipeType[]{smeltingRecipeType.getRecipeType(), RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Constants.BRICK_SMOKER_BLOCK.get()), new RecipeType[]{smokingRecipeType.getRecipeType(), RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Constants.BRICK_BLAST_FURNACE_BLOCK.get()), new RecipeType[]{blastingRecipeType.getRecipeType(), RecipeTypes.FUELING});
    }
}

