/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.compat;

import de.cech12.brickfurnace.Constants;
import de.cech12.brickfurnace.blockentity.AbstractBrickFurnaceBlockEntity;
import java.util.function.Function;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.InterModComms;

public class TOPCompat {
    public static void register() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", PluginTOPRegistry::new);
    }

    public static class PluginTOPRegistry
    implements Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe probe) {
            probe.registerProvider(new IProbeInfoProvider(this){
                private static final IIconStyle FIRE_STYLE = new IconStyle().bounds(8, 8).textureBounds(8, 64);
                private static final ResourceLocation FIRE_ICON = ResourceLocation.withDefaultNamespace((String)"textures/block/campfire_fire.png");

                public ResourceLocation getID() {
                    return Constants.id("brickfurnaceinfo");
                }

                public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
                    BlockEntity blockEntity = level.getBlockEntity(iProbeHitData.getPos());
                    if (blockEntity instanceof AbstractBrickFurnaceBlockEntity) {
                        AbstractBrickFurnaceBlockEntity furnaceBlockEntity = (AbstractBrickFurnaceBlockEntity)blockEntity;
                        int burnTime = furnaceBlockEntity.dataAccess.get(0);
                        int cookTime = furnaceBlockEntity.dataAccess.get(2);
                        int cookTimeTotal = furnaceBlockEntity.dataAccess.get(3);
                        if (burnTime > 0) {
                            iProbeInfo.horizontal().icon(FIRE_ICON, 0, (int)(level.getGameTime() % 8L * 16L), FIRE_STYLE.getWidth(), FIRE_STYLE.getHeight(), FIRE_STYLE).text(CompoundText.create().label("top.brickfurnace.fuel").text(": ").style(TextStyleClass.INFO).text((Component)Component.translatable((String)"top.brickfurnace.n_ticks", (Object[])new Object[]{burnTime})));
                        }
                        if (cookTime > 0) {
                            iProbeInfo.progress(cookTime, cookTimeTotal, (IProgressStyle)new ProgressStyle().suffix((Component)Component.literal((String)(" / " + cookTimeTotal))).alignment(ElementAlignment.ALIGN_CENTER));
                        }
                    }
                }
            });
            return null;
        }
    }
}

