/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.brickfurnace.blockentity;

import de.cech12.brickfurnace.platform.Services;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractBrickFurnaceBlockEntity
extends AbstractFurnaceBlockEntity {
    protected final RecipeType<? extends AbstractCookingRecipe> specificRecipeType;
    protected final RecipeType<? extends AbstractCookingRecipe> vanillaRecipeType;
    public static final int BURN_TIME = 0;
    public static final int RECIPES_USED = 1;
    public static final int COOK_TIME = 2;
    public static final int COOK_TIME_TOTAL = 3;
    public static final int INPUT = 0;
    public static final int FUEL = 1;
    public static final int OUTPUT = 2;
    protected RecipeHolder<? extends AbstractCookingRecipe> curRecipe;
    protected ItemStack failedMatch = ItemStack.EMPTY;

    public AbstractBrickFurnaceBlockEntity(BlockEntityType<?> blockEntityTypeIn, BlockPos blockPos, BlockState blockState, RecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn, RecipeType<? extends AbstractCookingRecipe> vanillaRecipeTypeIn) {
        super(blockEntityTypeIn, blockPos, blockState, vanillaRecipeTypeIn);
        this.specificRecipeType = specificRecipeTypeIn;
        this.vanillaRecipeType = vanillaRecipeTypeIn;
    }

    private boolean isBurning() {
        return this.dataAccess.get(0) > 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractBrickFurnaceBlockEntity entity) {
        boolean wasBurning = entity.isBurning();
        boolean dirty = false;
        if (entity.isBurning()) {
            entity.dataAccess.set(0, entity.dataAccess.get(0) - 1);
        }
        if (level == null || level.isClientSide) {
            return;
        }
        ItemStack fuel = (ItemStack)entity.items.get(1);
        if (entity.isBurning() || !fuel.isEmpty() && !((ItemStack)entity.items.get(0)).isEmpty()) {
            RecipeHolder<? extends AbstractCookingRecipe> irecipe = entity.getRecipe();
            boolean valid = entity.canBurn(irecipe);
            if (!entity.isBurning() && valid) {
                entity.dataAccess.set(0, entity.getBurnDuration(fuel));
                entity.dataAccess.set(1, entity.dataAccess.get(0));
                if (entity.isBurning()) {
                    dirty = true;
                    if (Services.PLATFORM.hasCraftingRemainingItem(fuel)) {
                        entity.items.set(1, (Object)Services.PLATFORM.getCraftingRemainingItem(fuel));
                    } else if (!fuel.isEmpty()) {
                        fuel.shrink(1);
                        if (fuel.isEmpty()) {
                            entity.items.set(1, (Object)Services.PLATFORM.getCraftingRemainingItem(fuel));
                        }
                    }
                }
            }
            if (entity.isBurning() && valid) {
                entity.dataAccess.set(2, entity.dataAccess.get(2) + 1);
                if (entity.dataAccess.get(2) == entity.dataAccess.get(3)) {
                    entity.dataAccess.set(2, 0);
                    entity.dataAccess.set(3, entity.getTotalCookTime(entity.getRecipe()));
                    entity.smeltItem(irecipe);
                    dirty = true;
                }
            } else {
                entity.dataAccess.set(2, 0);
            }
        } else if (!entity.isBurning() && entity.dataAccess.get(2) > 0) {
            entity.dataAccess.set(2, Mth.clamp((int)(entity.dataAccess.get(2) - 2), (int)0, (int)entity.dataAccess.get(3)));
        }
        if (wasBurning != entity.isBurning()) {
            dirty = true;
            level.setBlock(pos, (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(entity.isBurning())), 3);
        }
        if (dirty) {
            entity.setChanged();
        }
    }

    private boolean canBurn(@Nullable RecipeHolder<?> recipe) {
        ItemStack recipeOutput;
        if (!((ItemStack)this.items.get(0)).isEmpty() && recipe != null && !(recipeOutput = recipe.value().getResultItem((HolderLookup.Provider)this.getLevel().registryAccess())).isEmpty()) {
            ItemStack output = (ItemStack)this.items.get(2);
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)output, (ItemStack)recipeOutput)) {
                return false;
            }
            return output.getCount() + recipeOutput.getCount() <= output.getMaxStackSize();
        }
        return false;
    }

    private void smeltItem(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null && this.canBurn(recipe)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = recipe.value().getResultItem((HolderLookup.Provider)this.getLevel().registryAccess());
            ItemStack itemstack2 = (ItemStack)this.items.get(2);
            if (itemstack2.isEmpty()) {
                this.items.set(2, (Object)itemstack1.copy());
            } else if (itemstack2.getItem() == itemstack1.getItem()) {
                itemstack2.grow(itemstack1.getCount());
            }
            if (this.level != null && !this.level.isClientSide) {
                this.setRecipeUsed(recipe);
            }
            if (itemstack.getItem() == Blocks.WET_SPONGE.asItem() && !((ItemStack)this.items.get(1)).isEmpty() && ((ItemStack)this.items.get(1)).getItem() == Items.BUCKET) {
                this.items.set(1, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
        }
    }

    private int getTotalCookTime(RecipeHolder<? extends AbstractCookingRecipe> rec) {
        if (rec == null) {
            return 200;
        }
        if (this.specificRecipeType.getClass().isInstance(((AbstractCookingRecipe)rec.value()).getType())) {
            return ((AbstractCookingRecipe)rec.value()).getCookingTime();
        }
        return (int)((double)((AbstractCookingRecipe)rec.value()).getCookingTime() * Services.CONFIG.getCookTimeFactor());
    }

    public RecipeHolder<? extends AbstractCookingRecipe> getRecipe() {
        ItemStack input = this.getItem(0);
        if (input.isEmpty() || input == this.failedMatch) {
            return null;
        }
        SingleRecipeInput recipeInput = new SingleRecipeInput(input);
        if (this.level != null && this.curRecipe != null && ((AbstractCookingRecipe)this.curRecipe.value()).matches(recipeInput, this.level)) {
            this.dataAccess.set(3, this.getTotalCookTime(this.curRecipe));
            return this.curRecipe;
        }
        RecipeHolder rec = null;
        if (this.level != null && (rec = (RecipeHolder)this.level.getRecipeManager().getRecipeFor(this.specificRecipeType, (RecipeInput)recipeInput, this.level).orElse(null)) == null && Services.CONFIG.areVanillaRecipesEnabled()) {
            rec = this.level.getRecipeManager().getRecipesFor(this.vanillaRecipeType, (RecipeInput)recipeInput, this.level).stream().filter(abstractCookingRecipe -> Services.CONFIG.isRecipeAllowed(abstractCookingRecipe.id())).findFirst().orElse(null);
        }
        this.failedMatch = rec == null ? input : ItemStack.EMPTY;
        this.dataAccess.set(3, this.getTotalCookTime(rec));
        this.curRecipe = rec;
        return this.curRecipe;
    }

    public ContainerData getContainerData() {
        return this.dataAccess;
    }
}

