/*
 * Decompiled with CFR 0.152.
 */
package hal.studios.hpm.world.inventory;

import hal.studios.hpm.init.HpmModMenus;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class CutterinventoryMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;

    public CutterinventoryMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)HpmModMenus.CUTTERINVENTORY.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(229);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                this.boundItemMatcher = () -> itemstack == (hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem());
                IItemHandler cap = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM);
                if (cap != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else if (extraData.readableBytes() > 1) {
                IItemHandler cap;
                extraData.readByte();
                this.boundEntity = this.world.getEntity(extraData.readVarInt());
                if (this.boundEntity != null && (cap = (IItemHandler)this.boundEntity.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else {
                this.boundBlockEntity = this.world.getBlockEntity(pos);
                itemstack = this.boundBlockEntity;
                if (itemstack instanceof BaseContainerBlockEntity) {
                    BaseContainerBlockEntity baseContainerBlockEntity = (BaseContainerBlockEntity)itemstack;
                    this.internal = new InvWrapper((Container)baseContainerBlockEntity);
                    this.bound = true;
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 0, 13, 14){}));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 1, 31, 14){}));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 2, 49, 14){}));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 3, 67, 14){}));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 4, 85, 14){}));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 5, 103, 14){}));
        this.customSlots.put(6, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 6, 121, 14){}));
        this.customSlots.put(7, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 7, 139, 14){}));
        this.customSlots.put(8, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 8, 157, 14){}));
        this.customSlots.put(9, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 9, 175, 14){}));
        this.customSlots.put(10, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 10, 193, 14){}));
        this.customSlots.put(11, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 11, 211, 14){}));
        this.customSlots.put(12, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 12, 229, 14){}));
        this.customSlots.put(13, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 13, 247, 14){}));
        this.customSlots.put(14, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 14, 265, 14){}));
        this.customSlots.put(15, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 15, 283, 14){}));
        this.customSlots.put(16, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 16, 301, 14){}));
        this.customSlots.put(17, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 17, 319, 14){}));
        this.customSlots.put(18, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 18, 337, 14){}));
        this.customSlots.put(19, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 19, 355, 14){}));
        this.customSlots.put(20, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 20, 373, 14){}));
        this.customSlots.put(21, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 21, 391, 14){}));
        this.customSlots.put(22, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 22, 13, 32){}));
        this.customSlots.put(23, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 23, 31, 32){}));
        this.customSlots.put(24, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 24, 49, 32){}));
        this.customSlots.put(25, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 25, 67, 32){}));
        this.customSlots.put(26, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 26, 85, 32){}));
        this.customSlots.put(27, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 27, 103, 32){}));
        this.customSlots.put(28, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 28, 121, 32){}));
        this.customSlots.put(29, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 29, 139, 32){}));
        this.customSlots.put(30, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 30, 157, 32){}));
        this.customSlots.put(31, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 31, 175, 32){}));
        this.customSlots.put(32, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 32, 193, 32){}));
        this.customSlots.put(33, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 33, 211, 32){}));
        this.customSlots.put(34, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 34, 229, 32){}));
        this.customSlots.put(35, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 35, 247, 32){}));
        this.customSlots.put(36, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 36, 265, 32){}));
        this.customSlots.put(37, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 37, 283, 32){}));
        this.customSlots.put(38, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 38, 301, 32){}));
        this.customSlots.put(39, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 39, 319, 32){}));
        this.customSlots.put(40, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 40, 337, 32){}));
        this.customSlots.put(41, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 41, 355, 32){}));
        this.customSlots.put(42, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 42, 373, 32){}));
        this.customSlots.put(43, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 43, 391, 32){}));
        this.customSlots.put(44, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 44, 13, 50){}));
        this.customSlots.put(45, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 45, 31, 50){}));
        this.customSlots.put(46, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 46, 49, 50){}));
        this.customSlots.put(47, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 47, 67, 50){}));
        this.customSlots.put(48, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 48, 85, 50){}));
        this.customSlots.put(49, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 49, 103, 50){}));
        this.customSlots.put(50, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 50, 121, 50){}));
        this.customSlots.put(51, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 51, 139, 50){}));
        this.customSlots.put(52, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 52, 157, 50){}));
        this.customSlots.put(53, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 53, 175, 50){}));
        this.customSlots.put(54, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 54, 193, 50){}));
        this.customSlots.put(55, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 55, 211, 50){}));
        this.customSlots.put(56, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 56, 229, 50){}));
        this.customSlots.put(57, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 57, 247, 50){}));
        this.customSlots.put(58, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 58, 265, 50){}));
        this.customSlots.put(59, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 59, 283, 50){}));
        this.customSlots.put(60, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 60, 301, 50){}));
        this.customSlots.put(61, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 61, 319, 50){}));
        this.customSlots.put(62, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 62, 337, 50){}));
        this.customSlots.put(63, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 63, 355, 50){}));
        this.customSlots.put(64, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 64, 373, 50){}));
        this.customSlots.put(65, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 65, 391, 50){}));
        this.customSlots.put(66, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 66, 13, 68){}));
        this.customSlots.put(67, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 67, 31, 68){}));
        this.customSlots.put(68, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 68, 49, 68){}));
        this.customSlots.put(69, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 69, 67, 68){}));
        this.customSlots.put(70, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 70, 85, 68){}));
        this.customSlots.put(71, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 71, 103, 68){}));
        this.customSlots.put(72, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 72, 121, 68){}));
        this.customSlots.put(73, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 73, 139, 68){}));
        this.customSlots.put(74, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 74, 157, 68){}));
        this.customSlots.put(75, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 75, 175, 68){}));
        this.customSlots.put(76, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 76, 193, 68){}));
        this.customSlots.put(77, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 77, 211, 68){}));
        this.customSlots.put(78, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 78, 229, 68){}));
        this.customSlots.put(79, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 79, 247, 68){}));
        this.customSlots.put(80, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 80, 265, 68){}));
        this.customSlots.put(81, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 81, 283, 68){}));
        this.customSlots.put(82, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 82, 301, 68){}));
        this.customSlots.put(83, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 83, 319, 68){}));
        this.customSlots.put(84, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 84, 337, 68){}));
        this.customSlots.put(85, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 85, 355, 68){}));
        this.customSlots.put(86, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 86, 373, 68){}));
        this.customSlots.put(87, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 87, 391, 68){}));
        this.customSlots.put(88, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 88, 13, 86){}));
        this.customSlots.put(89, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 89, 31, 86){}));
        this.customSlots.put(90, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 90, 49, 86){}));
        this.customSlots.put(91, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 91, 67, 86){}));
        this.customSlots.put(92, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 92, 85, 86){}));
        this.customSlots.put(93, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 93, 103, 86){}));
        this.customSlots.put(94, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 94, 121, 86){}));
        this.customSlots.put(95, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 95, 139, 86){}));
        this.customSlots.put(96, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 96, 157, 86){}));
        this.customSlots.put(97, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 97, 175, 86){}));
        this.customSlots.put(98, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 98, 193, 86){}));
        this.customSlots.put(99, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 99, 211, 86){}));
        this.customSlots.put(100, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 100, 229, 86){}));
        this.customSlots.put(101, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 101, 247, 86){}));
        this.customSlots.put(102, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 102, 265, 86){}));
        this.customSlots.put(103, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 103, 283, 86){}));
        this.customSlots.put(104, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 104, 301, 86){}));
        this.customSlots.put(105, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 105, 319, 86){}));
        this.customSlots.put(106, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 106, 337, 86){}));
        this.customSlots.put(107, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 107, 355, 86){}));
        this.customSlots.put(108, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 108, 373, 86){}));
        this.customSlots.put(109, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 109, 391, 86){}));
        this.customSlots.put(110, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 110, 13, 104){}));
        this.customSlots.put(111, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 111, 31, 104){}));
        this.customSlots.put(112, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 112, 49, 104){}));
        this.customSlots.put(113, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 113, 67, 104){}));
        this.customSlots.put(114, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 114, 85, 104){}));
        this.customSlots.put(115, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 115, 103, 104){}));
        this.customSlots.put(116, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 116, 121, 104){}));
        this.customSlots.put(117, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 117, 139, 104){}));
        this.customSlots.put(118, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 118, 157, 104){}));
        this.customSlots.put(119, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 119, 175, 104){}));
        this.customSlots.put(120, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 120, 193, 104){}));
        this.customSlots.put(121, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 121, 211, 104){}));
        this.customSlots.put(122, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 122, 229, 104){}));
        this.customSlots.put(123, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 123, 247, 104){}));
        this.customSlots.put(124, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 124, 265, 104){}));
        this.customSlots.put(125, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 125, 283, 104){}));
        this.customSlots.put(126, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 126, 301, 104){}));
        this.customSlots.put(127, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 127, 319, 104){}));
        this.customSlots.put(128, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 128, 337, 104){}));
        this.customSlots.put(129, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 129, 355, 104){}));
        this.customSlots.put(130, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 130, 373, 104){}));
        this.customSlots.put(131, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 131, 391, 104){}));
        this.customSlots.put(132, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 132, 13, 122){}));
        this.customSlots.put(133, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 133, 31, 122){}));
        this.customSlots.put(134, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 134, 49, 122){}));
        this.customSlots.put(135, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 135, 67, 122){}));
        this.customSlots.put(136, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 136, 85, 122){}));
        this.customSlots.put(137, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 137, 103, 122){}));
        this.customSlots.put(138, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 138, 121, 122){}));
        this.customSlots.put(139, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 139, 139, 122){}));
        this.customSlots.put(140, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 140, 157, 122){}));
        this.customSlots.put(141, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 141, 175, 122){}));
        this.customSlots.put(142, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 142, 193, 122){}));
        this.customSlots.put(143, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 143, 211, 122){}));
        this.customSlots.put(144, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 144, 229, 122){}));
        this.customSlots.put(145, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 145, 247, 122){}));
        this.customSlots.put(146, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 146, 265, 122){}));
        this.customSlots.put(147, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 147, 283, 122){}));
        this.customSlots.put(148, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 148, 301, 122){}));
        this.customSlots.put(149, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 149, 319, 122){}));
        this.customSlots.put(150, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 150, 337, 122){}));
        this.customSlots.put(151, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 151, 355, 122){}));
        this.customSlots.put(152, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 152, 373, 122){}));
        this.customSlots.put(153, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 153, 391, 122){}));
        this.customSlots.put(154, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 154, 13, 140){}));
        this.customSlots.put(155, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 155, 31, 140){}));
        this.customSlots.put(156, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 156, 31, 140){}));
        this.customSlots.put(157, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 157, 49, 140){}));
        this.customSlots.put(158, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 158, 67, 140){}));
        this.customSlots.put(159, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 159, 85, 140){}));
        this.customSlots.put(160, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 160, 103, 140){}));
        this.customSlots.put(161, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 161, 121, 140){}));
        this.customSlots.put(162, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 162, 139, 140){}));
        this.customSlots.put(163, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 163, 157, 140){}));
        this.customSlots.put(164, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 164, 175, 140){}));
        this.customSlots.put(165, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 165, 193, 140){}));
        this.customSlots.put(166, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 166, 211, 140){}));
        this.customSlots.put(167, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 167, 229, 140){}));
        this.customSlots.put(168, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 168, 247, 140){}));
        this.customSlots.put(169, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 169, 265, 140){}));
        this.customSlots.put(170, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 170, 283, 140){}));
        this.customSlots.put(171, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 171, 301, 140){}));
        this.customSlots.put(172, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 172, 319, 140){}));
        this.customSlots.put(173, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 173, 337, 140){}));
        this.customSlots.put(174, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 174, 355, 140){}));
        this.customSlots.put(175, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 175, 373, 140){}));
        this.customSlots.put(176, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 176, 391, 140){}));
        this.customSlots.put(177, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 177, 175, 158){}));
        this.customSlots.put(178, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 178, 193, 158){}));
        this.customSlots.put(179, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 179, 211, 158){}));
        this.customSlots.put(180, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 180, 229, 158){}));
        this.customSlots.put(181, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 181, 247, 158){}));
        this.customSlots.put(182, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 182, 265, 158){}));
        this.customSlots.put(183, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 183, 283, 158){}));
        this.customSlots.put(184, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 184, 301, 158){}));
        this.customSlots.put(185, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 185, 319, 158){}));
        this.customSlots.put(186, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 186, 337, 158){}));
        this.customSlots.put(187, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 187, 355, 158){}));
        this.customSlots.put(188, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 188, 373, 158){}));
        this.customSlots.put(189, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 189, 391, 158){}));
        this.customSlots.put(190, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 190, 175, 176){}));
        this.customSlots.put(191, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 191, 193, 176){}));
        this.customSlots.put(192, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 192, 211, 176){}));
        this.customSlots.put(193, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 193, 229, 176){}));
        this.customSlots.put(194, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 194, 247, 176){}));
        this.customSlots.put(195, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 195, 265, 176){}));
        this.customSlots.put(196, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 196, 283, 176){}));
        this.customSlots.put(197, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 197, 301, 176){}));
        this.customSlots.put(198, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 198, 319, 176){}));
        this.customSlots.put(199, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 199, 337, 176){}));
        this.customSlots.put(200, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 200, 355, 176){}));
        this.customSlots.put(201, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 201, 373, 176){}));
        this.customSlots.put(202, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 202, 391, 176){}));
        this.customSlots.put(203, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 203, 175, 194){}));
        this.customSlots.put(204, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 204, 193, 194){}));
        this.customSlots.put(205, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 205, 211, 194){}));
        this.customSlots.put(206, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 206, 229, 194){}));
        this.customSlots.put(207, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 207, 247, 194){}));
        this.customSlots.put(208, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 208, 265, 194){}));
        this.customSlots.put(209, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 209, 283, 194){}));
        this.customSlots.put(210, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 210, 301, 194){}));
        this.customSlots.put(211, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 211, 319, 194){}));
        this.customSlots.put(212, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 212, 337, 194){}));
        this.customSlots.put(213, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 213, 355, 194){}));
        this.customSlots.put(214, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 214, 373, 194){}));
        this.customSlots.put(215, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 215, 391, 194){}));
        this.customSlots.put(216, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 216, 175, 212){}));
        this.customSlots.put(217, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 217, 193, 212){}));
        this.customSlots.put(218, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 218, 211, 212){}));
        this.customSlots.put(219, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 219, 229, 212){}));
        this.customSlots.put(220, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 220, 247, 212){}));
        this.customSlots.put(221, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 221, 265, 212){}));
        this.customSlots.put(222, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 222, 283, 212){}));
        this.customSlots.put(223, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 223, 301, 212){}));
        this.customSlots.put(224, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 224, 319, 212){}));
        this.customSlots.put(225, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 225, 337, 212){}));
        this.customSlots.put(226, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 226, 355, 212){}));
        this.customSlots.put(227, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 227, 373, 212){}));
        this.customSlots.put(228, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 228, 391, 212){}));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 12 + sj * 18, 168 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 12 + si * 18, 226));
        }
    }

    public boolean stillValid(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.getBlockState().getBlock());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.isAlive();
            }
        }
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 229) {
                if (!this.moveItemStackTo(itemstack1, 229, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 229, false)) {
                if (index < 256 ? !this.moveItemStackTo(itemstack1, 256, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 229, 256, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        p_38904_.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    int l = slot1.getMaxStackSize(p_38904_);
                    slot1.setByPlayer(p_38904_.split(Math.min(p_38904_.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.drop(this.internal.getStackInSlot(j), false);
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof IItemHandlerModifiable)) continue;
                    IItemHandlerModifiable ihm = (IItemHandlerModifiable)iItemHandler;
                    ihm.setStackInSlot(j, ItemStack.EMPTY);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.getInventory().placeItemBackInInventory(this.internal.getStackInSlot(i));
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof IItemHandlerModifiable)) continue;
                    IItemHandlerModifiable ihm = (IItemHandlerModifiable)iItemHandler;
                    ihm.setStackInSlot(i, ItemStack.EMPTY);
                }
            }
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

