/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextInputScreen
extends Screen {
    @NotNull
    protected Consumer<String> callback;
    protected ExtendedEditBox input;
    protected ExtendedButton cancelButton;
    protected ExtendedButton doneButton;
    protected ConsumingSupplier<TextInputScreen, Boolean> textValidator = null;
    protected Tooltip textValidatorFeedbackTooltip = null;

    @NotNull
    public static TextInputScreen build(@NotNull Component title, @Nullable CharacterFilter filter, @NotNull Consumer<String> callback) {
        return new TextInputScreen(title, filter, callback);
    }

    public TextInputScreen(@NotNull Component title, @Nullable CharacterFilter filter, @NotNull Consumer<String> callback) {
        super(title);
        this.callback = callback;
        this.input = new ExtendedEditBox(Minecraft.getInstance().font, 0, 0, 200, 20, (Component)Component.empty());
        this.input.setMaxLength(10000);
        this.input.setCharacterFilter(filter);
        UIBase.applyDefaultWidgetSkinTo(this.input);
    }

    protected void init() {
        this.addWidget((GuiEventListener)this.input);
        this.setFocused((GuiEventListener)this.input);
        this.cancelButton = new ExtendedButton(0, 0, 100, 20, (Component)Component.translatable((String)"fancymenu.guicomponents.cancel"), button -> this.callback.accept(null));
        this.addWidget((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.doneButton = new ExtendedButton(0, 0, 100, 20, (Component)Component.translatable((String)"fancymenu.guicomponents.done"), button -> {
            if (this.isTextValid()) {
                this.callback.accept(this.input.getValue());
            }
        });
        this.addWidget((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.fill(0, 0, this.width, this.height, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        RenderSystem.enableBlend();
        MutableComponent t = this.title.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        int titleWidth = Minecraft.getInstance().font.width((FormattedText)t);
        graphics.drawString(this.font, (Component)t, this.width / 2 - titleWidth / 2, this.height / 2 - 30, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.input.setX(this.width / 2 - this.input.getWidth() / 2);
        this.input.setY(this.height / 2 - this.input.getHeight() / 2);
        this.input.render(graphics, mouseX, mouseY, partial);
        this.cancelButton.setX(this.width / 2 - 5 - this.cancelButton.getWidth());
        this.cancelButton.setY(this.height - 40);
        this.cancelButton.render(graphics, mouseX, mouseY, partial);
        this.doneButton.active = this.isTextValid();
        if (this.textValidatorFeedbackTooltip != null) {
            this.textValidatorFeedbackTooltip.setDefaultStyle();
        }
        this.doneButton.setTooltip(this.textValidatorFeedbackTooltip);
        this.doneButton.setX(this.width / 2 + 5);
        this.doneButton.setY(this.height - 40);
        this.doneButton.render(graphics, mouseX, mouseY, partial);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
    }

    public boolean keyPressed(int button, int p_96553_, int p_96554_) {
        if (button == 257 && this.isTextValid()) {
            this.callback.accept(this.input.getValue());
            return true;
        }
        return super.keyPressed(button, p_96553_, p_96554_);
    }

    public void onClose() {
        this.callback.accept(null);
    }

    public TextInputScreen setText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        this.input.setValue(text);
        return this;
    }

    public String getText() {
        return this.input.getValue();
    }

    protected boolean isTextValid() {
        if (this.textValidator != null) {
            return this.textValidator.get(this);
        }
        return true;
    }

    public TextInputScreen setTextValidator(@Nullable ConsumingSupplier<TextInputScreen, Boolean> textValidator) {
        this.textValidator = textValidator;
        return this;
    }

    public TextInputScreen setTextValidatorUserFeedback(@Nullable Tooltip feedback) {
        this.textValidatorFeedbackTooltip = feedback;
        return this;
    }
}

