/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.mcef;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFBrowser;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.keksuccino.fancymenu.util.mcef.BrowserHandler;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;

public class WrappedMCEFBrowser
extends AbstractWidget
implements Closeable,
NavigatableWidget {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final MCEFBrowser browser;
    protected final Minecraft minecraft = Minecraft.getInstance();
    protected boolean browserFocused = false;
    protected boolean interactable = true;
    protected float opacity = 1.0f;
    protected boolean autoHandle = true;
    protected volatile float volume = 1.0f;
    protected volatile boolean fullscreenAllVideos = false;
    protected volatile boolean autoPlayAllVideosOnLoad = true;
    protected volatile boolean muteAllMediaOnLoad = false;
    protected volatile boolean loopAllVideos = false;
    protected volatile boolean hideVideoControls = false;
    protected UUID genericIdentifier = UUID.randomUUID();

    @NotNull
    public static WrappedMCEFBrowser build(@NotNull String url, boolean transparent, boolean autoHandle) {
        WrappedMCEFBrowser b = new WrappedMCEFBrowser(url, transparent);
        b.autoHandle = autoHandle;
        return b;
    }

    @NotNull
    public static WrappedMCEFBrowser build(@NotNull String url, boolean transparent, boolean autoHandle, int x, int y, int width, int height) {
        WrappedMCEFBrowser b = WrappedMCEFBrowser.build(url, transparent, autoHandle);
        b.setSize(width, height);
        b.setPosition(x, y);
        return b;
    }

    protected WrappedMCEFBrowser(@NotNull String url, boolean transparent) {
        super(0, 0, 0, 0, (Component)Component.empty());
        this.browser = MCEF.createBrowser((String)url, (boolean)transparent);
        this.setVolume(this.volume);
        this.setSize(200, 200);
        this.setPosition(0, 0);
        MCEF.getClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                WrappedMCEFBrowser.this.setVolume(WrappedMCEFBrowser.this.volume);
                WrappedMCEFBrowser.this.setFullscreenAllVideos(WrappedMCEFBrowser.this.fullscreenAllVideos);
                WrappedMCEFBrowser.this.setAutoPlayAllVideosOnLoad(WrappedMCEFBrowser.this.autoPlayAllVideosOnLoad);
                WrappedMCEFBrowser.this.setMuteAllMediaOnLoad(WrappedMCEFBrowser.this.muteAllMediaOnLoad);
                WrappedMCEFBrowser.this.setLoopAllVideos(WrappedMCEFBrowser.this.loopAllVideos);
                WrappedMCEFBrowser.this.setHideVideoControls(WrappedMCEFBrowser.this.hideVideoControls);
                super.onLoadEnd(browser, frame, httpStatusCode);
            }
        });
    }

    protected void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        try {
            if (this.autoHandle) {
                BrowserHandler.notifyHandler(this.genericIdentifier.toString(), this);
            }
            RenderSystem.disableDepthTest();
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderTexture((int)0, (int)this.browser.getRenderer().getTextureID());
            Tesselator t = Tesselator.getInstance();
            BufferBuilder buffer = t.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            int alpha = (int)(this.opacity * 255.0f);
            buffer.addVertex((float)this.getX(), (float)(this.getY() + this.getHeight()), 0.0f).setUv(0.0f, 1.0f).setColor(255, 255, 255, alpha);
            buffer.addVertex((float)(this.getX() + this.getWidth()), (float)(this.getY() + this.getHeight()), 0.0f).setUv(1.0f, 1.0f).setColor(255, 255, 255, alpha);
            buffer.addVertex((float)(this.getX() + this.getWidth()), (float)this.getY(), 0.0f).setUv(1.0f, 0.0f).setColor(255, 255, 255, alpha);
            buffer.addVertex((float)this.getX(), (float)this.getY(), 0.0f).setUv(0.0f, 0.0f).setColor(255, 255, 255, alpha);
            BufferUploader.drawWithShader((MeshData)Objects.requireNonNull(buffer.build()));
            RenderSystem.setShaderTexture((int)0, (int)0);
            RenderSystem.enableDepthTest();
            graphics.flush();
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to render MCEFBrowser!", (Throwable)ex);
        }
    }

    public void onVolumeUpdated(@NotNull SoundSource soundSource, float newVolume) {
        this.setVolume(this.volume);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && this.interactable) {
            this.browserFocused = true;
            this.browser.sendMousePress(this.convertMouseX(mouseX), this.convertMouseY(mouseY), button);
            this.browser.setFocus(true);
            return true;
        }
        this.browserFocused = false;
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.interactable) {
            this.browser.sendMouseRelease(this.convertMouseX(mouseX), this.convertMouseY(mouseY), button);
            this.browser.setFocus(true);
        }
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (!this.interactable) {
            return;
        }
        this.browser.sendMouseMove(this.convertMouseX(mouseX), this.convertMouseY(mouseY));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isMouseOver(mouseX, mouseY) && this.interactable) {
            this.browser.sendMouseWheel(this.convertMouseX(mouseX), this.convertMouseY(mouseY), scrollY, 0);
            this.browser.setFocus(true);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.interactable && this.browserFocused) {
            this.browser.sendKeyPress(keyCode, (long)scanCode, modifiers);
            this.browser.setFocus(true);
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.interactable && this.browserFocused) {
            this.browser.sendKeyRelease(keyCode, (long)scanCode, modifiers);
            this.browser.setFocus(true);
            return true;
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.interactable && this.browserFocused) {
            if (codePoint == '\u0000') {
                return true;
            }
            this.browser.sendKeyTyped(codePoint, modifiers);
            this.browser.setFocus(true);
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return UIBase.isXYInArea(mouseX, mouseY, (double)this.getX(), (double)this.getY(), (double)this.getWidth(), (double)this.getHeight());
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.browser.resize(this.convertWidth(width), this.convertHeight(height));
    }

    protected int convertMouseX(double mouseX) {
        return (int)((mouseX - (double)this.getX()) * this.minecraft.getWindow().getGuiScale());
    }

    protected int convertMouseY(double mouseY) {
        return (int)((mouseY - (double)this.getY()) * this.minecraft.getWindow().getGuiScale());
    }

    protected int convertWidth(double width) {
        return (int)(width * this.minecraft.getWindow().getGuiScale());
    }

    protected int convertHeight(double height) {
        return (int)(height * this.minecraft.getWindow().getGuiScale());
    }

    public void setVolume(float volume) {
        this.volume = volume;
        String code = "document.querySelectorAll('audio, video').forEach(el => el.volume = " + this.getActualVolume() + ");";
        this.browser.executeJavaScript(code, this.browser.getURL(), 0);
    }

    public float getVolume() {
        return this.volume;
    }

    public float getActualVolume() {
        float actualVolume = this.volume;
        float soundSourceVolume = Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.MASTER);
        return actualVolume *= soundSourceVolume;
    }

    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
        if (!this.interactable) {
            this.browser.setFocus(false);
            this.browserFocused = false;
        }
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setAutoHandle(boolean autoHandle) {
        this.autoHandle = autoHandle;
    }

    public boolean isAutoHandle() {
        return this.autoHandle;
    }

    public void setFullscreenAllVideos(boolean fullscreenAllVideos) {
        this.fullscreenAllVideos = fullscreenAllVideos;
        String code = "document.querySelectorAll('video').forEach(video => {\n    if (video.requestFullscreen) {\n        video.requestFullscreen().catch(err => console.error('Fullscreen error:', err));\n    } else if (video.webkitRequestFullscreen) { // Safari compatibility\n        video.webkitRequestFullscreen().catch(err => console.error('Fullscreen error (webkit):', err));\n    } else if (video.msRequestFullscreen) { // IE/Edge compatibility\n        video.msRequestFullscreen().catch(err => console.error('Fullscreen error (ms):', err));\n    }\n});\n";
        if (this.fullscreenAllVideos) {
            this.browser.executeJavaScript(code, this.browser.getURL(), 0);
        }
    }

    public boolean isFullscreenAllVideos() {
        return this.fullscreenAllVideos;
    }

    public void setAutoPlayAllVideosOnLoad(boolean autoPlayAllVideosOnLoad) {
        this.autoPlayAllVideosOnLoad = autoPlayAllVideosOnLoad;
        String code = "document.querySelectorAll('video').forEach(video => {\n    video.play(); // Start playing the video\n});\n";
        if (this.autoPlayAllVideosOnLoad) {
            this.browser.executeJavaScript(code, this.browser.getURL(), 0);
        }
    }

    public boolean isAutoPlayAllVideosOnLoad() {
        return this.autoPlayAllVideosOnLoad;
    }

    public void setMuteAllMediaOnLoad(boolean muteAllMediaOnLoad) {
        this.muteAllMediaOnLoad = muteAllMediaOnLoad;
        String code = "document.querySelectorAll('audio, video').forEach(media => {\n    media.muted = %muted%; // Mute media\n});\n".replace("%muted%", "" + this.muteAllMediaOnLoad);
        this.browser.executeJavaScript(code, this.browser.getURL(), 0);
    }

    public boolean isMuteAllMediaOnLoad() {
        return this.muteAllMediaOnLoad;
    }

    public void setLoopAllVideos(boolean loopAllVideos) {
        this.loopAllVideos = loopAllVideos;
        String code = "document.querySelectorAll('video').forEach(video => {\n    video.loop = %loop%; // Set video to loop\n});\n".replace("%loop%", "" + this.loopAllVideos);
        this.browser.executeJavaScript(code, this.browser.getURL(), 0);
    }

    public boolean isLoopAllVideos() {
        return this.loopAllVideos;
    }

    public void setHideVideoControls(boolean hideVideoControls) {
        this.hideVideoControls = hideVideoControls;
        String codeRemove = "document.querySelectorAll('video').forEach(video => {\n    video.removeAttribute('controls'); // Hide video controls\n});\n";
        String codeAdd = "document.querySelectorAll('video').forEach(video => {\n    if (!video.hasAttribute('controls')) {\n        video.setAttribute('controls', 'controls'); // Add controls\n    }\n});\n";
        this.browser.executeJavaScript(this.hideVideoControls ? codeRemove : codeAdd, this.browser.getURL(), 0);
    }

    public boolean isHideVideoControls() {
        return this.hideVideoControls;
    }

    public void goBack() {
        if (this.browser.canGoBack()) {
            this.browser.goBack();
        }
        this.setVolume(this.volume);
    }

    public void goForward() {
        if (this.browser.canGoForward()) {
            this.browser.goForward();
        }
        this.setVolume(this.volume);
    }

    public String getUrl() {
        return this.browser.getURL();
    }

    public void setUrl(@NotNull String url) {
        this.browser.loadURL(url);
    }

    public void reload() {
        this.browser.reload();
        this.setVolume(this.volume);
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    @NotNull
    public MCEFBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
    }

    @Override
    public void close() throws IOException {
        this.browser.close(true);
    }
}

