/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.file;

import de.keksuccino.fancymenu.platform.Services;
import java.io.File;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;

public class GameDirectoryUtils {
    public static File getGameDirectory() {
        if (Services.PLATFORM.isOnClient()) {
            return Minecraft.getInstance().gameDirectory;
        }
        return new File("");
    }

    public static boolean isExistingGameDirectoryPath(@NotNull String path) {
        Objects.requireNonNull(path);
        path = ((String)path).replace("\\", "/");
        String gameDir = GameDirectoryUtils.getGameDirectory().getAbsolutePath().replace("\\", "/");
        if (!((String)path).startsWith(gameDir)) {
            path = gameDir + "/" + (String)path;
        }
        return new File((String)path).exists();
    }

    public static String getAbsoluteGameDirectoryPath(@NotNull String path) {
        try {
            path = path.replace("\\", "/");
            String gameDir = GameDirectoryUtils.getGameDirectory().getAbsolutePath().replace("\\", "/");
            if (!path.startsWith(gameDir)) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                return gameDir + "/" + path;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    public static String getPathWithoutGameDirectory(@NotNull String path) {
        Objects.requireNonNull(path);
        File f = new File(GameDirectoryUtils.getAbsoluteGameDirectoryPath(path));
        String p = f.getAbsolutePath().replace("\\", "/").replace(GameDirectoryUtils.getGameDirectory().getAbsolutePath().replace("\\", "/"), "");
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        return p;
    }
}

