/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.util.neoforge.NetworkHelperImpl;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class NetworkHelper {
    public static <T extends CustomPacketPayload> void registerC2S(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, NetworkManager.NetworkReceiver<T> handler) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), type, codec, handler);
    }

    public static <T extends CustomPacketPayload> void registerS2C(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, NetworkManager.NetworkReceiver<T> handler) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), type, codec, handler);
        } else {
            NetworkManager.registerS2CPayloadType(type, codec);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToAll(CustomPacketPayload.Type<?> type, MinecraftServer server, Packet<?> packet) {
        void var2_2;
        void var1_1;
        NetworkHelperImpl.sendToAll(type, (MinecraftServer)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendTo(CustomPacketPayload.Type<?> type, ServerPlayer player, Packet<?> packet) {
        void var2_2;
        void var1_1;
        NetworkHelperImpl.sendTo(type, (ServerPlayer)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends CustomPacketPayload> void sendToAll(MinecraftServer server, T packet) {
        void var1_1;
        NetworkHelperImpl.sendToAll(server, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends CustomPacketPayload> void sendTo(ServerPlayer player, T packet) {
        void var1_1;
        NetworkHelperImpl.sendTo(player, var1_1);
    }

    public static <B extends FriendlyByteBuf, V extends Enum<V>> StreamCodec<B, V> enumStreamCodec(final Class<V> enumClass) {
        return new StreamCodec<B, V>(){

            public V decode(B buf) {
                return buf.readEnum(enumClass);
            }

            public void encode(B buf, V value) {
                buf.writeEnum(value);
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final Function7<T1, T2, T3, T4, T5, T6, T7, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B buf) {
                Object t1 = codec1.decode(buf);
                Object t2 = codec2.decode(buf);
                Object t3 = codec3.decode(buf);
                Object t4 = codec4.decode(buf);
                Object t5 = codec5.decode(buf);
                Object t6 = codec6.decode(buf);
                Object t7 = codec7.decode(buf);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7);
            }

            public void encode(B buf, C object) {
                codec1.encode(buf, getter1.apply(object));
                codec2.encode(buf, getter2.apply(object));
                codec3.encode(buf, getter3.apply(object));
                codec4.encode(buf, getter4.apply(object));
                codec5.encode(buf, getter5.apply(object));
                codec6.encode(buf, getter6.apply(object));
                codec7.encode(buf, getter7.apply(object));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B buf) {
                Object t1 = codec1.decode(buf);
                Object t2 = codec2.decode(buf);
                Object t3 = codec3.decode(buf);
                Object t4 = codec4.decode(buf);
                Object t5 = codec5.decode(buf);
                Object t6 = codec6.decode(buf);
                Object t7 = codec7.decode(buf);
                Object t8 = codec8.decode(buf);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8);
            }

            public void encode(B buf, C object) {
                codec1.encode(buf, getter1.apply(object));
                codec2.encode(buf, getter2.apply(object));
                codec3.encode(buf, getter3.apply(object));
                codec4.encode(buf, getter4.apply(object));
                codec5.encode(buf, getter5.apply(object));
                codec6.encode(buf, getter6.apply(object));
                codec7.encode(buf, getter7.apply(object));
                codec8.encode(buf, getter8.apply(object));
            }
        };
    }
}

