/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.manager;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.net.SyncConfigFromServerPacket;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public enum ConfigManager {
    INSTANCE;

    final Map<String, TrackedConfig> pendingClient = new HashMap<String, TrackedConfig>();
    final Map<String, TrackedConfig> pendingServer = new HashMap<String, TrackedConfig>();
    private final Map<String, TrackedConfig> trackedConfigs = new HashMap<String, TrackedConfig>();
    private boolean inited = false;

    public static ConfigManager getInstance() {
        return INSTANCE;
    }

    public void init() {
        if (this.inited) {
            throw new IllegalStateException("already initialised!");
        }
        LifecycleEvent.SERVER_BEFORE_START.register(this::onServerStarting);
        PlayerEvent.PLAYER_JOIN.register(this::onPlayerLogin);
        this.inited = true;
    }

    public SNBTConfig registerClientConfig(SNBTConfig config, String groupPrefix) {
        return this.registerClientConfig(config, groupPrefix, TrackedConfig.NO_ACTION);
    }

    public SNBTConfig registerClientConfig(SNBTConfig config, String groupPrefix, BooleanConsumer onEdited) {
        this.pendingClient.put(config.key, TrackedConfig.createForRegistration(groupPrefix, false, config, false, onEdited));
        return config;
    }

    public SNBTConfig registerServerConfig(SNBTConfig config, String groupPrefix, boolean sync) {
        return this.registerServerConfig(config, groupPrefix, sync, TrackedConfig.NO_ACTION);
    }

    public SNBTConfig registerServerConfig(SNBTConfig config, String groupPrefix, boolean sync, BooleanConsumer onEdited) {
        this.pendingServer.put(config.key, TrackedConfig.createForRegistration(groupPrefix, true, config, sync, onEdited));
        return config;
    }

    public void save(String key) {
        TrackedConfig tc = this.trackedConfigs.get(key);
        if (tc == null) {
            throw new IllegalArgumentException("Unknown tracked config: " + key);
        }
        try {
            SNBT.tryWrite(tc.loadedFrom, (CompoundTag)Util.make((Object)((Object)new SNBTCompoundTag()), tc.config::write));
            FTBLibrary.LOGGER.debug("saved config name={} path={}", (Object)key, (Object)tc.loadedFrom);
        }
        catch (IOException e) {
            FTBLibrary.LOGGER.error("failed to save config {}: {}", (Object)tc, (Object)e.getMessage());
        }
    }

    public void syncFromServer(String serverConfigName, SNBTCompoundTag tag) {
        TrackedConfig tc = this.trackedConfigs.get(serverConfigName);
        if (tc != null) {
            tc.config.read(tag);
            tc.onEdited.accept(false);
            FTBLibrary.LOGGER.info("received server config settings for config: {}", (Object)serverConfigName);
        } else {
            FTBLibrary.LOGGER.error("received unknown config name {} from server!", (Object)serverConfigName);
        }
    }

    public void syncFromClient(String serverConfigName, SNBTCompoundTag tag, String playerName) {
        TrackedConfig tc = this.trackedConfigs.get(serverConfigName);
        if (tc != null) {
            tc.config.read(tag);
            tc.onEdited.accept(true);
            this.save(serverConfigName);
            FTBLibrary.LOGGER.info("received client config settings from {} for config: {}", (Object)playerName, (Object)serverConfigName);
        } else {
            FTBLibrary.LOGGER.error("player {} tried to sync an unknown config {} from client!", (Object)playerName, (Object)serverConfigName);
        }
    }

    private void onServerStarting(MinecraftServer server) {
        this.pendingServer.forEach((key, config) -> this.findAndLoad((String)key, (TrackedConfig)config, fileName -> server.getWorldPath(ConfigUtil.SERVER_CONFIG_DIR).resolve((String)fileName)));
        this.pendingServer.clear();
    }

    private void onPlayerLogin(ServerPlayer serverPlayer) {
        this.trackedConfigs.forEach((name, tc) -> {
            if (tc.synced) {
                NetworkHelper.sendTo(serverPlayer, SyncConfigFromServerPacket.create(tc.config));
            }
        });
    }

    void findAndLoad(String key, TrackedConfig protoTc, Function<String, Path> overridePathSupplier) {
        String fileName = key + ".snbt";
        Path primaryPath = ConfigUtil.CONFIG_DIR.resolve(fileName);
        Path overridePath = overridePathSupplier.apply(fileName);
        if (!Files.exists(primaryPath, new LinkOption[0]) && Files.exists(overridePath, new LinkOption[0])) {
            try {
                Files.move(overridePath, primaryPath, new CopyOption[0]);
                FTBLibrary.LOGGER.info("config migration: moved {} to {}", (Object)overridePath, (Object)primaryPath);
            }
            catch (IOException e) {
                FTBLibrary.LOGGER.error("can't move {} to {}: {}", (Object)overridePath, (Object)primaryPath, (Object)e.getMessage());
            }
        } else {
            ConfigManager.checkForIdenticalConfigFiles(key, primaryPath, overridePath);
        }
        if (Files.exists(overridePath, new LinkOption[0])) {
            protoTc.config.load(overridePath);
            this.track(key, protoTc.promoteToFull(overridePath));
        } else {
            protoTc.config.load(primaryPath);
            this.track(key, protoTc.promoteToFull(primaryPath));
        }
    }

    private static void checkForIdenticalConfigFiles(String key, Path primaryPath, Path overridePath) {
        try {
            if (Files.exists(primaryPath, new LinkOption[0]) && Files.exists(overridePath, new LinkOption[0]) && Files.mismatch(primaryPath, overridePath) == -1L) {
                FTBLibrary.LOGGER.info("{} and {} are identical; deleting {}", (Object)primaryPath, (Object)overridePath, (Object)overridePath);
                Files.delete(overridePath);
            }
        }
        catch (IOException e) {
            FTBLibrary.LOGGER.error("Caught exception while examining configs for {}: {}", (Object)key, (Object)e.getMessage());
        }
    }

    void track(String key, TrackedConfig trackedConfig) {
        this.trackedConfigs.put(key, trackedConfig);
        FTBLibrary.LOGGER.debug("tracking config {}, loaded from {}", (Object)key, (Object)trackedConfig.loadedFrom);
    }

    public void editedOnClient(String key) {
        TrackedConfig tc = this.trackedConfigs.get(key);
        if (tc != null) {
            tc.onEdited.accept(false);
        }
    }

    public Optional<ConfigGroup> createConfigGroup(String configName) {
        TrackedConfig tc = this.trackedConfigs.get(configName);
        return tc != null ? Optional.of(ConfigUtil.makeConfigEditGroup(tc.config, tc.groupPrefix, tc.isServerConfig)) : Optional.empty();
    }

    record TrackedConfig(Path loadedFrom, boolean isServerConfig, SNBTConfig config, boolean synced, BooleanConsumer onEdited, String groupPrefix) {
        static final BooleanConsumer NO_ACTION = isServer -> {};

        TrackedConfig clientMirrorOfServerConfig() {
            return new TrackedConfig(null, true, this.config, false, this.onEdited, this.groupPrefix);
        }

        static TrackedConfig createForRegistration(String groupPrefix, boolean isServerConfig, SNBTConfig config, boolean sync, BooleanConsumer onChanged) {
            return new TrackedConfig(null, isServerConfig, config, sync, onChanged, groupPrefix);
        }

        TrackedConfig promoteToFull(Path path) {
            return new TrackedConfig(path, this.isServerConfig, this.config, this.synced, this.onEdited, this.groupPrefix);
        }
    }
}

