/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.bindings.BlockWrapper;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record BlockStateComponent(boolean preferObjectForm) implements RecipeComponent<BlockState>
{
    public static final RecipeComponent<BlockState> BLOCK = new BlockStateComponent(true);
    public static final RecipeComponent<BlockState> BLOCK_STRING = new BlockStateComponent(false);

    @Override
    public Codec<BlockState> codec() {
        return BlockState.CODEC;
    }

    @Override
    public TypeInfo typeInfo() {
        return TypeInfo.of(BlockState.class);
    }

    @Override
    public BlockState wrap(Context cx, KubeRecipe recipe, Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockState.class, Block.class, JsonPrimitive.class}, (Object)object, n)) {
            case 0 -> {
                BlockState s;
                yield s = (BlockState)object;
            }
            case 1 -> {
                Block b = (Block)object;
                yield b.defaultBlockState();
            }
            case 2 -> {
                JsonPrimitive json = (JsonPrimitive)object;
                yield BlockWrapper.parseBlockState(RegistryAccessContainer.of(cx), json.getAsString());
            }
            default -> {
                Map<?, ?> map = MapJS.of(from);
                if (map == null) {
                    yield BlockWrapper.parseBlockState(RegistryAccessContainer.of(cx), String.valueOf(from));
                }
                yield (BlockState)BlockState.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonUtils.GSON.toJsonTree(from)).getPartialOrThrow(message -> {
                    throw new KubeRuntimeException("Failed to parse blockstate: " + message);
                });
            }
        };
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, BlockState value, ReplacementMatchInfo match) {
        BlockStatePredicate m2;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof BlockStatePredicate && (m2 = (BlockStatePredicate)replacementMatch).test(value);
    }

    @Override
    public boolean isEmpty(BlockState value) {
        return value.getBlock() == Blocks.AIR;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, BlockState value) {
        builder.append(value.kjs$getIdLocation());
    }

    @Override
    public String toString() {
        return this.preferObjectForm ? "block_state" : "block_state_string";
    }
}

