/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.miner;

import alexthw.starbunclemania.starbuncle.AuthorizedBehavior;
import alexthw.starbunclemania.starbuncle.StarbyItemBehavior;
import alexthw.starbunclemania.starbuncle.StoreItemGoal;
import alexthw.starbunclemania.starbuncle.miner.MineBlockGoal;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.ICosmeticItem;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToBedGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarbyMinerBehavior
extends StarbyItemBehavior
implements AuthorizedBehavior {
    public static final ResourceLocation MINER_ID = ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"starby_block_breaker");
    ItemStack toolToUse = ItemStack.EMPTY;
    UUID ownerUUID;

    public StarbyMinerBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.contains("givenTool")) {
            this.toolToUse = ItemStack.parseOptional((HolderLookup.Provider)entity.registryAccess(), (CompoundTag)tag.getCompound("givenTool"));
        }
        if (tag.contains("ownerUUID")) {
            this.ownerUUID = tag.getUUID("ownerUUID");
        }
        this.goals.add(new WrappedGoal(1, (Goal)new GoToBedGoal(entity, (StarbyBehavior)this)));
        this.goals.add(new WrappedGoal(3, new MineBlockGoal<StarbyMinerBehavior>(entity, this)));
        this.goals.add(new WrappedGoal(5, new StoreItemGoal<StarbyMinerBehavior>(entity, this)));
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return super.mobInteract(player, hand);
        }
        ItemStack playerHand = player.getItemInHand(hand);
        if (playerHand.isEmpty() || playerHand.getItem() instanceof BlockItem || playerHand.getItem() instanceof ICosmeticItem || playerHand.getItem() instanceof DominionWand || playerHand.getItem() instanceof ItemScroll) {
            return super.mobInteract(player, hand);
        }
        if (!this.toolToUse.isEmpty()) {
            this.starbuncle.level().addFreshEntity((Entity)new ItemEntity(this.starbuncle.level(), this.starbuncle.getX(), this.starbuncle.getY(), this.starbuncle.getZ(), this.toolToUse.copy()));
        }
        this.toolToUse = playerHand.split(1);
        this.syncTag();
        return super.mobInteract(player, hand);
    }

    public boolean clearOrRemove() {
        boolean no_connections = super.clearOrRemove();
        if (no_connections && !this.toolToUse.isEmpty()) {
            this.starbuncle.level().addFreshEntity((Entity)new ItemEntity(this.starbuncle.level(), this.starbuncle.getX(), this.starbuncle.getY(), this.starbuncle.getZ(), this.toolToUse.copy()));
            this.toolToUse = ItemStack.EMPTY;
            return false;
        }
        return no_connections;
    }

    @Override
    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    @Override
    @NotNull
    public UUID getOwnerUUID() {
        return this.ownerUUID == null ? ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)this.starbuncle.level())).getUUID() : this.ownerUUID;
    }

    public ItemStack getToolToUse() {
        return this.toolToUse.isEmpty() ? Items.IRON_PICKAXE.getDefaultInstance() : this.toolToUse;
    }

    public void getTooltip(Consumer<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.storing", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.mining", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (!this.itemScroll.isEmpty()) {
            tooltip.accept((Component)Component.translatable((String)"ars_nouveau.filtering_with", (Object[])new Object[]{this.itemScroll.getHoverName().getString()}));
        }
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.tool", (Object[])new Object[]{this.getToolToUse().getHoverName().getString()}));
    }

    public boolean isPickupDisabled() {
        return this.starbuncle.getCosmeticItem().getItem() == ItemsRegistry.STARBUNCLE_SHADES.get();
    }

    public void pickUpItem(ItemEntity itemEntity) {
        super.pickUpItem(itemEntity);
        if (this.getValidStorePos(itemEntity.getItem()) == null || this.isPickupDisabled()) {
            return;
        }
        Starbuncle starbuncleWithRoom = this.starbuncle.getStarbuncleWithSpace();
        starbuncleWithRoom.setHeldStack(itemEntity.getItem());
        itemEntity.remove(Entity.RemovalReason.DISCARDED);
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, this.starbuncle.getSoundSource(), 1.0f, 1.0f);
        for (ItemEntity i : this.level.getEntitiesOfClass(ItemEntity.class, this.starbuncle.getBoundingBox().inflate(3.0))) {
            if (itemEntity.getItem().getCount() >= itemEntity.getItem().getMaxStackSize()) break;
            int maxTake = starbuncleWithRoom.getHeldStack().getMaxStackSize() - starbuncleWithRoom.getHeldStack().getCount();
            if (!ItemStack.isSameItemSameComponents((ItemStack)i.getItem(), (ItemStack)starbuncleWithRoom.getHeldStack())) continue;
            int toTake = Math.min(i.getItem().getCount(), maxTake);
            i.getItem().shrink(toTake);
            starbuncleWithRoom.getHeldStack().grow(toTake);
        }
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null && this.getItemCapFromTile(storedPos, side) != null) {
            this.addToPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.store"));
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null && !this.level.isOutsideBuildHeight(storedPos)) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.miner"));
        }
    }

    public boolean canGoToBed() {
        return this.isBedPowered() || this.getValidMinePos() == null && (this.starbuncle.getHeldStack().isEmpty() || this.getValidStorePos(this.starbuncle.getHeldStack()) == null);
    }

    public ResourceLocation getRegistryName() {
        return MINER_ID;
    }

    @Nullable
    public BlockPos getValidMinePos() {
        if (this.FROM_LIST.isEmpty()) {
            return null;
        }
        for (BlockPos p : this.FROM_LIST) {
            if (!this.isPositionValidMine(p)) continue;
            return p;
        }
        return null;
    }

    public boolean isPositionValidMine(BlockPos p) {
        if (p == null || !this.level.isLoaded(p)) {
            return false;
        }
        BlockState blockState = this.level.getBlockState(p);
        if (blockState.isAir()) {
            return false;
        }
        if (this.getToolToUse().getDestroySpeed(blockState) <= 0.0f || blockState.getDestroySpeed((BlockGetter)this.level, p) <= 0.0f) {
            return false;
        }
        if (blockState.requiresCorrectToolForDrops() && !this.getToolToUse().isCorrectToolForDrops(blockState)) {
            return false;
        }
        List drops = blockState.getDrops(new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)this.starbuncle.position()).withParameter(LootContextParams.TOOL, (Object)this.getToolToUse()).withParameter(LootContextParams.ENCHANTMENT_ACTIVE, (Object)true));
        for (ItemStack stack : drops) {
            if (stack.isEmpty() || this.getValidStorePos(stack) != null) continue;
            return false;
        }
        return true;
    }

    public boolean canMineBlock(BlockPos targetPos) {
        Starbuncle starbuncle;
        Level level;
        if (this.ownerUUID != null && (level = this.starbuncle.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            starbuncle = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(this.getOwnerUUID(), ""));
        } else {
            starbuncle = this.starbuncle;
        }
        Starbuncle playerEntity = starbuncle;
        return BlockUtil.destroyRespectsClaim((LivingEntity)playerEntity, (Level)this.starbuncle.level(), (BlockPos)targetPos);
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (!this.toolToUse.isEmpty()) {
            tag.put("givenTool", this.toolToUse.save((HolderLookup.Provider)this.starbuncle.registryAccess()));
        }
        if (this.ownerUUID != null) {
            tag.putUUID("ownerUUID", this.ownerUUID);
        }
        return super.toTag(tag);
    }

    public ItemStack getStackForRender() {
        if (!this.toolToUse.isEmpty()) {
            return this.toolToUse;
        }
        return super.getStackForRender();
    }
}

