/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEventListener;
import org.jetbrains.annotations.Nullable;
import wile.redstonepen.libmc.Registries;

public class StandardEntityBlocks {

    public static abstract class StandardBlockEntity
    extends BlockEntity {
        public StandardBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public void tick() {
        }

        public CompoundTag writenbt(HolderLookup.Provider hlp, CompoundTag nbt) {
            return this.writenbt(hlp, nbt, false);
        }

        public CompoundTag writenbt(HolderLookup.Provider hlp, CompoundTag nbt, boolean sync_packet) {
            return nbt;
        }

        public CompoundTag readnbt(HolderLookup.Provider hlp, CompoundTag nbt) {
            return nbt;
        }

        protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider hlp) {
            this.readnbt(hlp, nbt);
        }

        protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider hlp) {
            super.saveAdditional(this.writenbt(hlp, nbt, false), hlp);
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider hlp) {
            return this.writenbt(hlp, super.getUpdateTag(hlp), true);
        }
    }

    public static interface IStandardEntityBlock<ET extends StandardBlockEntity>
    extends EntityBlock {
        default public boolean isBlockEntityTicking(Level world, BlockState state) {
            return false;
        }

        default public InteractionResult useOpenGui(BlockState state, Level world, BlockPos pos, Player player) {
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity te = world.getBlockEntity(pos);
            if (!(te instanceof MenuProvider)) {
                return InteractionResult.FAIL;
            }
            player.openMenu((MenuProvider)te);
            return InteractionResult.CONSUME;
        }

        @Nullable
        default public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            BlockEntityType<?> tet = Registries.getBlockEntityTypeOfBlock(state.getBlock());
            return tet == null ? null : tet.create(pos, state);
        }

        @Nullable
        default public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> te_type) {
            return world.isClientSide || !this.isBlockEntityTicking(world, state) ? null : (w, p, s, te) -> ((StandardBlockEntity)te).tick();
        }

        @Nullable
        default public <T extends BlockEntity> GameEventListener getListener(ServerLevel world, T te) {
            return null;
        }
    }
}

