/*
 * Decompiled with CFR 0.152.
 */
package com.mcdart.xp_synthesiser.util;

import com.mcdart.xp_synthesiser.Config;

public class HelperFunctions {
    public static double getTickCost(int totalXp, int totalTicks) {
        int defaultCost = Config.GENERAL.xpPointCost.getAsInt();
        double baseCost = (double)totalXp * (double)defaultCost / (double)totalTicks;
        double scalingCost = (double)(totalXp ^ 3) * (double)defaultCost / ((double)(totalTicks ^ 2) * ((double)defaultCost / 10.0));
        return baseCost + scalingCost;
    }

    public static double getLevelFromXP(int xp) {
        if (xp > 0 && xp <= 352) {
            return Math.sqrt(xp + 9) - 3.0;
        }
        if (xp > 352 && xp <= 1507) {
            return 8.1 + Math.sqrt(0.4 * ((double)xp - 195.975));
        }
        if (xp > 1507) {
            return 18.055555555555557 + Math.sqrt(0.2222222222222222 * ((double)xp - 752.9861111111111));
        }
        return 0.0;
    }

    public static int getXPfromLevel(double level) {
        if (level > 0.0 && level <= 16.0) {
            return (int)Math.round(Math.pow(level, 2.0) + 6.0 * level);
        }
        if (level > 16.0 && level <= 31.0) {
            return (int)Math.round(2.5 * Math.pow(level, 2.0) - 40.5 * level + 360.0);
        }
        if (level > 31.0) {
            return (int)Math.round(4.5 * Math.pow(level, 2.0) - 162.5 * level + 2220.0);
        }
        return 0;
    }

    public static double roundTo(double num, int sigFigs) {
        return (double)Math.round(num * Math.pow(10.0, sigFigs)) / Math.pow(10.0, sigFigs);
    }
}

