/*
 * Decompiled with CFR 0.152.
 */
package com.mcdart.xp_synthesiser.items;

import com.mcdart.xp_synthesiser.XPSynthesiser;
import com.mcdart.xp_synthesiser.items.KillRecorderData;
import com.mcdart.xp_synthesiser.util.HelperFunctions;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class KillRecorderItem
extends Item {
    public KillRecorderItem(boolean recording) {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        if (!pLevel.isClientSide() && pPlayer.isShiftKeyDown()) {
            this.toggleRecording(pLevel, (ServerPlayer)pPlayer, itemStack);
            pPlayer.setItemInHand(pUsedHand, itemStack);
        } else if (pLevel.isClientSide()) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)pLevel.isClientSide());
    }

    private void toggleRecording(Level pLevel, ServerPlayer player, ItemStack itemStack) {
        KillRecorderData currentData = (KillRecorderData)itemStack.getOrDefault((DataComponentType)XPSynthesiser.KILL_RECORDER_DATA_COMPONENT.get(), (Object)KillRecorderData.createEmpty());
        long currentTime = pLevel.getGameTime();
        if (!currentData.recording()) {
            itemStack.update((DataComponentType)XPSynthesiser.KILL_RECORDER_DATA_COMPONENT.get(), (Object)currentData, data -> new KillRecorderData(true, 0, currentTime, 0L));
            player.displayClientMessage((Component)Component.literal((String)"Kill Recording: Started (Data Cleared)"), true);
        } else {
            itemStack.update((DataComponentType)XPSynthesiser.KILL_RECORDER_DATA_COMPONENT.get(), (Object)currentData, data -> new KillRecorderData(false, data.xp(), data.recordingStart(), currentTime));
            player.displayClientMessage((Component)Component.literal((String)"Kill Recording: Stopped"), true);
        }
    }

    public void appendHoverText(@NotNull ItemStack itemStack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.TooltipContext ttc, @NotNull List<Component> component, @NotNull TooltipFlag ttf) {
        super.appendHoverText(itemStack, ttc, component, ttf);
        KillRecorderData krData = (KillRecorderData)itemStack.getOrDefault((DataComponentType)XPSynthesiser.KILL_RECORDER_DATA_COMPONENT.get(), (Object)KillRecorderData.createEmpty());
        if (krData.recordingStart() > 0L) {
            if (krData.recordingEnd() == 0L) {
                component.add((Component)Component.literal((String)"RECORDING").withStyle(ChatFormatting.RED));
            }
            component.add((Component)Component.literal((String)((krData.recording() ? "Current " : "Stored ") + "XP: \u00a76" + krData.xp())).withStyle(ChatFormatting.BLUE));
            if (krData.recordingEnd() > 0L) {
                long timeTaken = krData.recordingEnd() - krData.recordingStart();
                component.add((Component)Component.literal((String)("Ticks Elapsed: \u00a76" + timeTaken)).withStyle(ChatFormatting.BLUE));
                if (krData.xp() > 0) {
                    int costPerTick = (int)HelperFunctions.getTickCost(krData.xp(), (int)timeTaken);
                    component.add((Component)Component.literal((String)("Cost Per Tick: \u00a76" + costPerTick)).withStyle(ChatFormatting.BLUE));
                }
            }
        } else {
            component.add((Component)Component.literal((String)"Shift and click to start recording").withStyle(ChatFormatting.GOLD));
        }
    }
}

