/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.neoforge;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.inventory.fluid.PolyFluidBlock;
import net.creeperhost.polylib.inventory.items.PolyInventoryBlock;
import net.creeperhost.polylib.inventory.power.PolyEnergyBlock;
import net.creeperhost.polylib.inventory.power.PolyEnergyItem;
import net.creeperhost.polylib.neoforge.NeoForgeClientEvents;
import net.creeperhost.polylib.neoforge.NeoForgeEvents;
import net.creeperhost.polylib.neoforge.inventory.fluid.PolyNeoFluidWrapper;
import net.creeperhost.polylib.neoforge.inventory.power.PolyNeoEnergyWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

@Mod(value="polylib")
public class PolyLibNeoForge {
    public PolyLibNeoForge(IEventBus modEventBus) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            NeoForgeClientEvents.init(modEventBus);
        }
        PolyLib.init();
        NeoForgeEvents.init();
        modEventBus.addListener(EventPriority.LOWEST, this::registerCapabilities);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        PolyLib.LOGGER.info("=====Registering Capabilities=====");
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof PolyEnergyItem)) continue;
            PolyEnergyItem polyEnergyItem = (PolyEnergyItem)item;
            PolyLib.LOGGER.info("Adding EnergyStore Item to " + item.getDescription().getString());
            event.registerItem(Capabilities.EnergyStorage.ITEM, (object, object2) -> new PolyNeoEnergyWrapper(polyEnergyItem.getEnergyStorage((ItemStack)object)), new ItemLike[]{item});
        }
        for (BlockEntityType blockEntityType : BuiltInRegistries.BLOCK_ENTITY_TYPE) {
            try {
                BlockEntity blockEntity;
                ResourceLocation reg = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)blockEntityType);
                ModContainer mod = ModList.get().getModContainerById(reg.getNamespace()).orElse(null);
                if (mod == null || mod.getModInfo().getDependencies().stream().noneMatch(e -> e.getModId().equals("polylib")) || (blockEntity = blockEntityType.create(BlockPos.ZERO, Blocks.AIR.defaultBlockState())) == null) continue;
                if (blockEntity instanceof PolyInventoryBlock) {
                    event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType, (entity, side) -> ((PolyInventoryBlock)entity).getContainer((Direction)side) == null ? null : new InvWrapper(((PolyInventoryBlock)entity).getContainer((Direction)side)));
                }
                if (blockEntity instanceof PolyEnergyBlock) {
                    event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, (entity, side) -> ((PolyEnergyBlock)entity).getEnergyStorage((Direction)side) == null ? null : new PolyNeoEnergyWrapper(((PolyEnergyBlock)entity).getEnergyStorage((Direction)side)));
                }
                if (!(blockEntity instanceof PolyFluidBlock)) continue;
                event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, blockEntityType, (entity, side) -> ((PolyFluidBlock)entity).getFluidHandler((Direction)side) == null ? null : new PolyNeoFluidWrapper(((PolyFluidBlock)entity).getFluidHandler((Direction)side)));
            }
            catch (Throwable throwable) {}
        }
    }
}

