/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data;

import java.util.function.Consumer;
import net.creeperhost.polylib.PolyLibClient;
import net.creeperhost.polylib.data.TileDataManager;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.network.PolyLibNetwork;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public interface DataManagerBlock {
    public static final int SAVE = 8;
    public static final int SYNC = 4;
    public static final int CLIENT_CONTROL = 2;
    public static final int SAVE_TO_ITEM = 1;
    public static final int SAVE_BOTH = 9;

    public TileDataManager<?> getDataManager();

    default public void sendPacketToServer(int id, Consumer<FriendlyByteBuf> packetWriter) {
        TileDataManager<?> manager = this.getDataManager();
        if (!manager.tile.getLevel().isClientSide()) {
            return;
        }
        Player player = PolyLibClient.getClientPlayer();
        if (player == null) {
            return;
        }
        AbstractContainerMenu container = player.containerMenu;
        PolyLibNetwork.sendPacketToServerTile(player.registryAccess(), buf -> {
            buf.writeVarInt(container.containerId);
            buf.writeVarInt(id);
            packetWriter.accept((FriendlyByteBuf)buf);
        });
    }

    default public <T> void sendDataValueToServer(AbstractDataStore<T> data, T value) {
        TileDataManager<?> manager = this.getDataManager();
        if (!manager.tile.getLevel().isClientSide()) {
            return;
        }
        Player player = PolyLibClient.getClientPlayer();
        if (player == null) {
            return;
        }
        int index = manager.dataOrder.indexOf(data);
        PolyLibNetwork.sendDataValueToServerTile(player.registryAccess(), buf -> {
            buf.writeVarInt(player.containerMenu.containerId);
            Object prev = data.get();
            data.set(value);
            buf.writeVarInt(index);
            data.toBytes((RegistryFriendlyByteBuf)buf);
            data.set(prev);
            data.isDirty(true);
        });
    }

    default public void handlePacketFromClient(ServerPlayer player, int id, FriendlyByteBuf buf) {
    }
}

