/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.item.data.Pigment;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class PigmentJarItem
extends GAGItem {
    public static final int MAX_AMOUNT = 64;
    public static final int DYE_AMOUNT = 4;

    public PigmentJarItem() {
        super(new Item.Properties().stacksTo(16));
    }

    @Nullable
    public static Pigment getPigment(ItemStack stack) {
        return (Pigment)stack.get(GAGRegistry.PIGMENT_DATA);
    }

    public static boolean isEmpty(ItemStack stack) {
        Pigment pigment = PigmentJarItem.getPigment(stack);
        return pigment == null || pigment.isEmpty();
    }

    public static int getRgbColor(ItemStack stack) {
        Pigment pigment = PigmentJarItem.getPigment(stack);
        return pigment == null ? -1 : pigment.rgb();
    }

    public static int getColorAmount(ItemStack stack) {
        Pigment pigment = PigmentJarItem.getPigment(stack);
        return pigment == null ? 0 : pigment.amount();
    }

    public static boolean isNonEmptyJar(ItemStack stack) {
        return stack.is((Item)GAGRegistry.PIGMENT_JAR.get()) && !PigmentJarItem.isEmpty(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        if (PigmentJarItem.isEmpty(stack)) {
            list.add((Component)Component.translatable((String)"item.gag.pigment_jar.contents.empty").withStyle(ChatFormatting.ITALIC).withStyle(GAGUtil.TOOLTIP_FLAVOUR));
            GAGUtil.appendInfoTooltip(list, List.of(Component.translatable((String)"item.gag.pigment_jar.info.empty.1").withStyle(GAGUtil.TOOLTIP_MAIN), Component.translatable((String)"item.gag.pigment_jar.info.empty.2").withStyle(GAGUtil.TOOLTIP_EXTRA)));
        } else {
            Pigment pigment = Objects.requireNonNull(PigmentJarItem.getPigment(stack));
            list.add((Component)Component.translatable((String)"item.gag.pigment_jar.contents", (Object[])new Object[]{GAGUtil.asStyledValue(pigment.amount(), 32.0, Integer.toString(pigment.amount())), Component.literal((String)pigment.hex()).withStyle(s -> s.withColor(pigment.rgb()))}).withStyle(GAGUtil.TOOLTIP_FLAVOUR));
            GAGUtil.appendInfoTooltip(list, List.of(Component.translatable((String)"item.gag.pigment_jar.info.filled.1").withStyle(GAGUtil.TOOLTIP_MAIN), Component.translatable((String)"item.gag.pigment_jar.info.filled.2").withStyle(GAGUtil.TOOLTIP_EXTRA)));
        }
    }

    @Override
    public Collection<ItemStack> getAdditionalSubItems() {
        return (Collection)Util.make((Object)ItemStackLinkedSet.createTypeAndComponentsSet(), set -> {
            for (DyeColor color : DyeColor.values()) {
                set.add(Pigment.forText(color).asJar());
            }
        });
    }

    public Component getName(ItemStack stack) {
        Component name = super.getName(stack);
        Pigment pigment = PigmentJarItem.getPigment(stack);
        if (pigment == null) {
            return name;
        }
        return name.copy().withStyle(s -> s.withColor(pigment.rgb()));
    }
}

