/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.integration.emi.EmiPigmentJarFromDyeRecipe;
import ky.someone.mods.gag.integration.emi.EmiPigmentJarMixingRecipe;
import ky.someone.mods.gag.integration.emi.EmiPigmentJarSplittingRecipe;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;

@EmiEntrypoint
public class GAGEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        ClientLevel level = Minecraft.getInstance().level;
        registry.addRecipe((EmiRecipe)new EmiPigmentJarFromDyeRecipe());
        registry.addRecipe((EmiRecipe)new EmiPigmentJarMixingRecipe());
        registry.addRecipe((EmiRecipe)new EmiPigmentJarSplittingRecipe());
        EmiWorldInteractionRecipe hearthstoneEnergizing = EmiWorldInteractionRecipe.builder().id(GAGUtil.id("emi_recipes/hearthstone_energizing")).leftInput((EmiIngredient)EmiStack.of(GAGRegistry.HEARTHSTONE)).output(EmiStack.of(GAGRegistry.ENERGIZED_HEARTHSTONE)).rightInput((EmiIngredient)new CustomNameEmiListIngredient(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{Items.LIGHTNING_ROD.getDefaultInstance(), (ItemStack)Util.make((Object)Items.TRIDENT.getDefaultInstance(), it -> it.enchant(level.holderOrThrow(Enchantments.CHANNELING), 1))})), (Component)Component.translatable((String)"info.gag.lightning_crafting_hint").withColor(11460313)), true).supportsRecipeTree(true).build();
        registry.addRecipe((EmiRecipe)hearthstoneEnergizing);
    }

    public record CustomNameEmiListIngredient(EmiIngredient wrapped, Component name) implements EmiIngredient
    {
        public List<EmiStack> getEmiStacks() {
            return this.wrapped.getEmiStacks();
        }

        public EmiIngredient copy() {
            return this.copyWith(id -> id);
        }

        private EmiIngredient copyWith(UnaryOperator<EmiIngredient> op) {
            return new CustomNameEmiListIngredient((EmiIngredient)op.apply(this.wrapped), (Component)this.name.copy());
        }

        public long getAmount() {
            return this.wrapped.getAmount();
        }

        public EmiIngredient setAmount(long amount) {
            return this.copyWith(id -> id.setAmount(amount));
        }

        public float getChance() {
            return this.wrapped.getChance();
        }

        public EmiIngredient setChance(float chance) {
            return this.copyWith(id -> id.setChance(chance));
        }

        public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
            this.wrapped.render(draw, x, y, delta, flags);
        }

        public List<ClientTooltipComponent> getTooltip() {
            return (List)Util.make(new ArrayList(this.wrapped.getTooltip()), it -> it.set(0, ClientTooltipComponent.create((FormattedCharSequence)this.name.getVisualOrderText())));
        }
    }
}

