/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.integration.emi;

import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Random;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.item.data.Pigment;
import ky.someone.mods.gag.recipe.pigment.PigmentJarMixingRecipe;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class EmiPigmentJarMixingRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeColor> DYES = List.of(DyeColor.values());

    public EmiPigmentJarMixingRecipe() {
        super(List.of(EmiStack.of(GAGRegistry.PIGMENT_JAR), EmiStack.of(GAGRegistry.PIGMENT_JAR)), EmiStack.of(GAGRegistry.PIGMENT_JAR), PigmentJarMixingRecipe.ID);
    }

    public SlotWidget getInputWidget(int slot, int x, int y) {
        return new GeneratedSlotWidget(r -> {
            ItemStack first = this.randomPigment((Random)r).asJar();
            ItemStack second = this.randomPigment((Random)r).asJar();
            return switch (slot) {
                case 0 -> EmiStack.of((ItemStack)first);
                case 1 -> EmiStack.of((ItemStack)second);
                default -> EmiStack.EMPTY;
            };
        }, this.unique, x, y);
    }

    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getJarForRecipe, this.unique, x, y);
    }

    private EmiStack getJarForRecipe(Random random) {
        Pigment first = this.randomPigment(random);
        Pigment second = this.randomPigment(random);
        return EmiStack.of((ItemStack)first.mix(second).asJar());
    }

    private Pigment randomPigment(Random random) {
        int color = random.nextInt(0x2000000);
        int amount = random.nextInt(32) + 1;
        return Pigment.ofRgb(color, amount);
    }
}

