/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.entity;

import java.util.ArrayList;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.config.TargetFilter;
import ky.someone.mods.gag.entity.AbstractDynamiteEntity;
import ky.someone.mods.gag.network.FishsplosionPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class FishingDynamiteEntity
extends AbstractDynamiteEntity {
    public static final TagKey<EntityType<?>> FISH_TAG = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)GAGUtil.id("fishing_dynamite_fish"));

    public FishingDynamiteEntity(EntityType<? extends FishingDynamiteEntity> type, Level level) {
        super(type, level);
    }

    public FishingDynamiteEntity(double x, double y, double z, Level level) {
        super(GAGRegistry.FISHING_DYNAMITE.get(), x, y, z, level);
    }

    public FishingDynamiteEntity(LivingEntity owner, Level level) {
        super(GAGRegistry.FISHING_DYNAMITE.get(), owner, level);
    }

    public void tick() {
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        this.level().addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, this.getX(-vec3.x) + this.random.nextDouble() * 0.6 - 0.3, this.getY(-vec3.y) + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ(-vec3.z) + this.random.nextDouble() * 0.6 - 0.3, vec3.x, vec3.y, vec3.z);
        if (this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(1.2));
        }
    }

    @Override
    public void detonate(Vec3 pos) {
        Fishsplosion explosion;
        int r = GAGConfig.dynamite.fishingRadius();
        Level level = this.level();
        if (!EventHooks.onExplosionStart((Level)level, (Explosion)(explosion = new Fishsplosion(level, (Entity)this, pos.x, pos.y, pos.z, r)))) {
            explosion.explode();
            explosion.finalizeExplosion(false);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new FishsplosionPayload(explosion), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected Item getDefaultItem() {
        return (Item)GAGRegistry.FISHING_DYNAMITE_ITEM.get();
    }

    public static class Fishsplosion
    extends Explosion {
        private int fishHit = 0;
        public final Vec3 pos = new Vec3(this.x, this.y, this.z);
        public final float radius = this.radius();
        private final boolean isInWater;

        public Fishsplosion(Level level, @Nullable Entity entity, double x, double y, double z, float radius) {
            super(level, entity, x, y, z, radius, false, Explosion.BlockInteraction.KEEP);
            double eps = 0.028;
            this.isInWater = BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)this.pos, (double)eps, (double)eps, (double)eps)).anyMatch(pos -> level.getFluidState(pos).is(FluidTags.WATER));
        }

        public void explode() {
            if (!this.isInWater) {
                return;
            }
            AABB hitbox = AABB.unitCubeFromLowerCorner((Vec3)this.pos).inflate((double)this.radius);
            for (LivingEntity entity : this.level.getEntitiesOfClass(LivingEntity.class, hitbox)) {
                double distSqr = entity.distanceToSqr(this.pos);
                if (distSqr > (double)(this.radius * this.radius) || !entity.isInWater() || entity.ignoreExplosion((Explosion)this)) continue;
                TargetFilter filter = GAGConfig.dynamite.fishingTargets();
                if (GAGConfig.dynamite.fishingInstakill() && filter.isFish((Entity)entity)) {
                    ++this.fishHit;
                    entity.hurt(this.damageSource, Float.MAX_VALUE);
                    continue;
                }
                double relDist = Math.sqrt(distSqr) / (double)this.radius;
                double seen = Fishsplosion.getSeenPercent((Vec3)this.pos, (Entity)entity);
                double damageFactor = (1.0 - relDist) * seen;
                float damage = (float)((double)((int)(damageFactor * damageFactor + damageFactor)) / 2.0 * 7.0 * (double)this.radius + 1.0);
                if (filter.isFish((Entity)entity)) {
                    ++this.fishHit;
                    entity.hurt(this.damageSource, damage * 2.0f);
                    continue;
                }
                if (!GAGConfig.dynamite.fishingDamageAll()) continue;
                entity.hurt(this.damageSource, damage / 2.0f);
            }
        }

        public void finalizeExplosion(boolean isClient) {
            if (isClient) {
                RandomSource random = this.level.random;
                if (this.isInWater) {
                    int particleCount = (int)(this.radius * 4.0f);
                    ArrayList<Vec3> points = new ArrayList<Vec3>();
                    for (int i = 0; i < particleCount; ++i) {
                        double angle = random.nextDouble() * Math.PI * 2.0;
                        double dist = random.nextDouble() * (double)this.radius;
                        double x = this.pos.x + Math.cos(angle) * dist;
                        double z = this.pos.z + Math.sin(angle) * dist;
                        points.add(new Vec3(x, 0.0, z));
                    }
                    BlockPos cur = BlockPos.containing((Position)this.pos).above();
                    while (this.level.isInWorldBounds(cur) && !this.level.getFluidState(cur).isEmpty()) {
                        for (Vec3 p : points) {
                            this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, p.x, (double)cur.getY() + 0.5, p.z, 0.0, 0.1, 0.0);
                        }
                        cur = cur.above();
                    }
                    for (int i = 0; i < particleCount * 4; ++i) {
                        double angle = random.nextDouble() * Math.PI * 2.0;
                        double dist = random.nextDouble() * (double)this.radius;
                        double x = this.pos.x + Math.cos(angle) * dist;
                        double y = (double)cur.getY() + 0.5;
                        double z = this.pos.z + Math.sin(angle) * dist;
                        this.level.addParticle((ParticleOptions)ParticleTypes.FISHING, x, y, z, 0.0, 0.05, 0.0);
                        this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, x, y, z, 0.0, 0.2, 0.0);
                        this.level.addParticle((ParticleOptions)ParticleTypes.SPLASH, x, y, z, 0.0, 0.1, 0.0);
                    }
                    this.level.playLocalSound(cur, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 0.3f, 1.5f, false);
                } else {
                    for (int i = 0; i < 20; ++i) {
                        this.level.addParticle((ParticleOptions)ParticleTypes.FISHING, this.pos.x + random.nextGaussian(), this.pos.y + (double)random.nextFloat(), this.pos.z + random.nextGaussian(), 0.0, 0.05, 0.0);
                    }
                    this.level.playLocalSound(this.pos.x, this.pos.y, this.pos.z, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.6f, (1.0f + (random.nextFloat() - random.nextFloat()) * 0.2f) * 0.7f, false);
                }
            }
            if (this.isInWater) {
                this.level.playSound(null, this.pos.x, this.pos.y, this.pos.z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 0.6f, 1.0f);
                if (!isClient) {
                    int add = GAGConfig.dynamite.fishingAdditionalLoot();
                    int fishDropped = this.fishHit;
                    ArrayList itemsToDrop = new ArrayList();
                    LootParams lootParams = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)this.pos).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this.getDirectSourceEntity()).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.getIndirectSourceEntity()).create(LootContextParamSets.FISHING);
                    LootTable lootTable = this.level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING_FISH);
                    for (int i = 0; i < add && !((double)fishDropped > 1.5 * (double)add); ++i) {
                        double chance = 1.0 / (1.0 + Math.exp((double)fishDropped - 0.75 * (double)add));
                        if (!(this.level.random.nextDouble() < chance)) continue;
                        lootTable.getRandomItems(lootParams, itemsToDrop::add);
                        ++fishDropped;
                    }
                    for (ItemStack itemStack : itemsToDrop) {
                        this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.x, this.y, this.z, itemStack));
                    }
                }
            }
        }
    }
}

