/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.TemporalPouchItem;
import ky.someone.mods.gag.item.data.Pigment;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="gag")
public class GAGCommands {
    public static final SimpleCommandExceptionType INVALID_COLOR = new SimpleCommandExceptionType((Message)Component.literal((String)"Invalid rgb!"));

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        GAGCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gag").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"pigment_jar").then(Commands.argument((String)"rgb", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> {
            String clrString = StringArgumentType.getString((CommandContext)ctx, (String)"rgb");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            try {
                int color = Integer.parseInt(clrString, 16);
                ItemStack stack = Pigment.ofRgb(color, amount).asJar();
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                if (player.addItem(stack)) {
                    player.containerMenu.broadcastChanges();
                } else {
                    ItemEntity asEntity = player.drop(stack, false);
                    if (asEntity != null) {
                        asEntity.setNoPickUpDelay();
                        asEntity.setTarget(player.getUUID());
                    }
                }
                return 1;
            }
            catch (NumberFormatException e) {
                throw INVALID_COLOR.create();
            }
        }))))).then(Commands.literal((String)"give_time").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            int time = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"ticks");
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (!(stack.getItem() instanceof TemporalPouchItem)) continue;
                int storedGrains = TemporalPouchItem.getStoredGrains(stack);
                int newTime = Math.min(storedGrains + time, GAGConfig.temporalPouch.capacity());
                TemporalPouchItem.setStoredGrains(stack, newTime);
                player.inventoryMenu.broadcastChanges();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.gag.give_time.success", (Object[])new Object[]{time, player.getDisplayName()}), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"commands.gag.give_time.no_pouch", (Object[])new Object[]{player.getDisplayName()}));
            return 0;
        })))));
    }
}

