/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.item.LabelingToolItem;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.item.data.Pigment;
import ky.someone.mods.gag.menu.LabelingMenu;
import ky.someone.mods.gag.network.RenameItemPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class LabelingMenuScreen
extends AbstractContainerScreen<LabelingMenu>
implements ContainerListener {
    private static final boolean UNUSED_UI = true;
    private static final ResourceLocation BG = GAGUtil.id("textures/gui/container/labeling_tool.png");
    private EditBox labelBox;

    public LabelingMenuScreen(LabelingMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.titleLabelX = 60;
        this.titleLabelY = 8;
    }

    protected void init() {
        super.init();
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.labelBox = new EditBox(this.font, i + 62, j + 24, 103, 12, LabelingToolItem.TITLE);
        this.labelBox.setCanLoseFocus(false);
        this.labelBox.setTextColor(-1);
        this.labelBox.setTextColorUneditable(-1);
        this.labelBox.setBordered(false);
        this.labelBox.setMaxLength(50);
        this.labelBox.setValue("");
        this.labelBox.setResponder(this::nameChanged);
        this.addWidget((GuiEventListener)this.labelBox);
        this.setInitialFocus((GuiEventListener)this.labelBox);
        this.labelBox.setEditable(false);
        ((LabelingMenu)this.menu).addSlotListener(this);
    }

    public void removed() {
        super.removed();
        ((LabelingMenu)this.menu).removeSlotListener(this);
    }

    public void resize(Minecraft minecraft, int i, int j) {
        String name = this.labelBox.getValue();
        this.init(minecraft, i, j);
        this.labelBox.setValue(name);
    }

    public boolean keyPressed(int i, int j, int k) {
        if (i == 256) {
            this.minecraft.player.closeContainer();
        }
        if (this.labelBox.keyPressed(i, j, k)) {
            return true;
        }
        if (this.labelBox.canConsumeInput()) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public void render(GuiGraphics graphics, int i, int j, float f) {
        super.render(graphics, i, j, f);
        RenderSystem.disableBlend();
        this.labelBox.render(graphics, i, j, f);
        this.renderTooltip(graphics, i, j);
    }

    public void renderBg(GuiGraphics graphics, float f, int i, int j) {
        int cx = (this.width - this.imageWidth) / 2;
        int cy = (this.height - this.imageHeight) / 2;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)cx, (float)cy, 0.0f);
        graphics.blit(BG, 0, 0, 0, 0, this.imageWidth, this.imageHeight);
        graphics.blit(BG, 6, 40, 0, 166, 164, 31);
        graphics.blit(BG, 59, 20, 0, 197, 110, 16);
        graphics.blit(BG, 76, 41, 176, 0, 18, 18);
        graphics.blit(BG, 134, 41, 176, 0, 18, 18);
        graphics.blit(BG, 103, 43, 176, 18, 22, 15);
        ItemStack pigmentStack = ((LabelingMenu)this.menu).getSlot(1).getItem();
        if (PigmentJarItem.isNonEmptyJar(pigmentStack)) {
            Pigment pigment = Objects.requireNonNull(PigmentJarItem.getPigment(pigmentStack));
            float ratio = (float)pigment.amount() / 64.0f;
            poseStack.pushPose();
            if (ratio > 0.0f) {
                int u = 1;
                int v = 214;
                int x = 7;
                int y = 64;
                int w = (int)(162.0f * ratio);
                int h = 5;
                int color = pigment.rgb();
                float rf = (float)FastColor.ARGB32.red((int)color) / 255.0f;
                float gf = (float)FastColor.ARGB32.green((int)color) / 255.0f;
                float bf = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
                graphics.setColor(rf, gf, bf, 1.0f);
                graphics.blit(BG, x, y, u, v, w, h);
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void nameChanged(String name) {
        if (!name.isEmpty()) {
            String s = name;
            Slot slot = ((LabelingMenu)this.menu).getSlot(0);
            if (slot.hasItem() && !slot.getItem().has(DataComponents.CUSTOM_NAME) && name.equals(slot.getItem().getHoverName().getString()) && !((LabelingMenu)this.menu).getSlot(1).hasItem()) {
                s = "";
            }
            ((LabelingMenu)this.menu).setName(s);
            PacketDistributor.sendToServer((CustomPacketPayload)new RenameItemPayload(s), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void slotChanged(AbstractContainerMenu menu, int i, ItemStack stack) {
        if (i == 0) {
            this.labelBox.setValue(stack.isEmpty() ? "" : stack.getHoverName().getString());
            this.labelBox.setEditable(!stack.isEmpty());
            this.setFocused((GuiEventListener)this.labelBox);
        } else if (i == 1) {
            this.nameChanged(this.labelBox.getValue());
        }
    }

    public void dataChanged(AbstractContainerMenu menu, int i, int j) {
    }
}

