/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag;

import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public interface GAGUtil {
    public static final String MOD_ID = "gag";
    public static final UnaryOperator<Style> TOOLTIP_MAIN = style -> style.withColor(16562523);
    public static final UnaryOperator<Style> TOOLTIP_EXTRA = style -> style.withColor(1036780).withItalic(Boolean.valueOf(true));
    public static final UnaryOperator<Style> TOOLTIP_FLAVOUR = style -> style.withColor(ChatFormatting.GRAY);
    public static final UnaryOperator<Style> COLOUR_TRUE = style -> style.withColor(5164173);
    public static final UnaryOperator<Style> COLOUR_FALSE = style -> style.withColor(16608605);
    public static final UnaryOperator<Style> COLOUR_INFO = style -> style.withColor(0x5555FF);

    public static void appendInfoTooltip(List<Component> tooltip, List<Component> info) {
        boolean isShift = Screen.hasShiftDown();
        tooltip.add((Component)Component.translatable((String)"\u2139").append((Component)Component.translatable((String)" (Shift)").withStyle(isShift ? ChatFormatting.DARK_GRAY : ChatFormatting.GRAY)).withStyle(COLOUR_INFO));
        if (isShift) {
            tooltip.addAll(info);
        }
    }

    public static Component styledBool(boolean b) {
        return Component.translatable((String)(b ? "\u2714" : "\u2718")).withStyle(b ? COLOUR_TRUE : COLOUR_FALSE);
    }

    public static Style styledRatio(Style parent, double ratio) {
        double clampedRatio = Mth.clamp((double)ratio, (double)0.0, (double)1.5);
        return parent.withColor(Mth.hsvToRgb((float)((float)clampedRatio / 3.0f), (float)1.0f, (float)1.0f));
    }

    public static Component asStyledValue(double value, double max) {
        return GAGUtil.asStyledValue(value, max, Double.toString(value));
    }

    public static Component asStyledValue(double value, double max, String formattedValue) {
        return Component.translatable((String)formattedValue).withStyle(GAGUtil.styledRatio(Style.EMPTY, value / max));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static ResourceKey<Level> dimension(ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
    }

    public static <U> U TODO() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

