/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.mekanism;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.CompoundChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.DifferenceChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.EmptyChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.SingleChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.TagChemicalIngredient;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public interface MekanismChemicalWrapper {
    public static final TypeInfo CHEMICAL_TYPE_INFO = TypeInfo.of(Chemical.class);
    public static final TypeInfo CHEMICAL_STACK_TYPE_INFO = TypeInfo.of(ChemicalStack.class);
    public static final TypeInfo CHEMICAL_INGREDIENT_TYPE_INFO = TypeInfo.of(ChemicalIngredient.class);
    public static final TypeInfo CHEMICAL_STACK_INGREDIENT_TYPE_INFO = TypeInfo.of(ChemicalStackIngredient.class);

    public static Chemical of(Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Chemical.class, ChemicalStack.class}, (Object)object, n)) {
            case -1 -> MekanismAPI.EMPTY_CHEMICAL;
            case 0 -> {
                Chemical c;
                yield c = (Chemical)object;
            }
            case 1 -> {
                ChemicalStack c = (ChemicalStack)object;
                yield c.getChemical();
            }
            default -> {
                String str = from.toString();
                if (str.isEmpty() || str.equals("mekanism:empty")) {
                    yield MekanismAPI.EMPTY_CHEMICAL;
                }
                yield (Chemical)MekanismAPI.CHEMICAL_REGISTRY.get(ResourceLocation.parse((String)str));
            }
        };
    }

    public static ChemicalStack stack(Chemical chemical, long amount) {
        return new ChemicalStack(chemical, amount);
    }

    public static ChemicalIngredient ingredientExcept(ChemicalIngredient ingredient, ChemicalIngredient except) {
        return new DifferenceChemicalIngredient(ingredient, except);
    }

    public static ChemicalIngredient ingredientIntersection(List<ChemicalIngredient> children) {
        return new CompoundChemicalIngredient(children);
    }

    public static ChemicalStackIngredient ingredientStack(ChemicalIngredient ingredient, long amount) {
        return new ChemicalStackIngredient(ingredient, amount);
    }

    public static ChemicalStack stackOf(Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChemicalStack.class, Chemical.class}, (Object)object, n)) {
            case -1 -> {
                ChemicalStack var3_3;
                yield var3_3 = null;
            }
            case 0 -> {
                ChemicalStack c;
                ChemicalStack var3_4;
                yield var3_4 = (c = (ChemicalStack)object);
            }
            case 1 -> {
                ChemicalStack var3_5;
                Chemical c = (Chemical)object;
                yield var3_5 = new ChemicalStack(c, 1000L);
            }
            default -> {
                String str = from.toString();
                if (str.isEmpty() || str.equals("mekanism:empty")) {
                    ChemicalStack var3_6;
                    yield var3_6 = ChemicalStack.EMPTY;
                }
                try {
                    ChemicalStack var3_7;
                    yield var3_7 = MekanismChemicalWrapper.readStack(new StringReader(str));
                }
                catch (CommandSyntaxException ex) {
                    ChemicalStack var3_8;
                    ex.printStackTrace();
                    yield var3_8 = ChemicalStack.EMPTY;
                }
            }
        };
    }

    public static Chemical read(StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        return (Chemical)MekanismAPI.CHEMICAL_REGISTRY.get(ResourceLocation.read((StringReader)reader));
    }

    public static ChemicalStack readStack(StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        long amount = FluidWrapper.readFluidAmount((StringReader)reader);
        Chemical chemical = MekanismChemicalWrapper.read(reader);
        return new ChemicalStack(chemical, amount);
    }

    public static ChemicalIngredient ingredientOf(Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChemicalIngredient.class, ChemicalStackIngredient.class, ChemicalStack.class, Chemical.class, Iterable.class}, (Object)object, n)) {
            case -1 -> {
                EmptyChemicalIngredient var3_3;
                yield var3_3 = EmptyChemicalIngredient.INSTANCE;
            }
            case 0 -> {
                ChemicalIngredient c;
                ChemicalIngredient var3_4 = c = (ChemicalIngredient)object;
                yield var3_4;
            }
            case 1 -> {
                ChemicalStackIngredient c = (ChemicalStackIngredient)object;
                ChemicalIngredient var3_5 = c.ingredient();
                yield var3_5;
            }
            case 2 -> {
                ChemicalStack c = (ChemicalStack)object;
                SingleChemicalIngredient var3_6 = new SingleChemicalIngredient(c.getChemicalHolder());
                yield var3_6;
            }
            case 3 -> {
                Chemical c = (Chemical)object;
                SingleChemicalIngredient var3_7 = new SingleChemicalIngredient(c.getAsHolder());
                yield var3_7;
            }
            case 4 -> {
                EmptyChemicalIngredient var3_8;
                Iterable itr = (Iterable)object;
                ArrayList<ChemicalIngredient> a = new ArrayList<ChemicalIngredient>();
                for (Object o : itr) {
                    ChemicalIngredient i = MekanismChemicalWrapper.ingredientOf(o);
                    if (i.isEmpty()) continue;
                    a.add(i);
                }
                yield var3_8 = a.isEmpty() ? EmptyChemicalIngredient.INSTANCE : (a.size() == 1 ? (ChemicalIngredient)a.getFirst() : new CompoundChemicalIngredient(a));
            }
            default -> {
                String str = from.toString();
                if (str.isEmpty() || str.equals("mekanism:empty")) {
                    EmptyChemicalIngredient var3_9;
                    yield var3_9 = EmptyChemicalIngredient.INSTANCE;
                }
                try {
                    ChemicalIngredient var3_10 = MekanismChemicalWrapper.readIngredient(new StringReader(str));
                    yield var3_10;
                }
                catch (CommandSyntaxException ex) {
                    EmptyChemicalIngredient var3_11;
                    ex.printStackTrace();
                    yield var3_11 = EmptyChemicalIngredient.INSTANCE;
                }
            }
        };
    }

    public static ChemicalIngredient readIngredient(StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        if (reader.peek() == '#') {
            reader.skip();
            return new TagChemicalIngredient(TagKey.create((ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)ResourceLocation.read((StringReader)reader)));
        }
        return new SingleChemicalIngredient(MekanismChemicalWrapper.read(reader).getAsHolder());
    }

    @HideFromJS
    public static ChemicalStackIngredient stackIngredientOf(Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChemicalStackIngredient.class, ChemicalIngredient.class, ChemicalStack.class, Chemical.class}, (Object)object, n)) {
            case -1 -> {
                ChemicalStackIngredient var3_3;
                yield var3_3 = new ChemicalStackIngredient((ChemicalIngredient)EmptyChemicalIngredient.INSTANCE, 1L);
            }
            case 0 -> {
                ChemicalStackIngredient c;
                ChemicalStackIngredient var3_4;
                yield var3_4 = (c = (ChemicalStackIngredient)object);
            }
            case 1 -> {
                ChemicalStackIngredient var3_5;
                ChemicalIngredient c = (ChemicalIngredient)object;
                yield var3_5 = new ChemicalStackIngredient(c, 1000L);
            }
            case 2 -> {
                ChemicalStackIngredient var3_6;
                ChemicalStack c = (ChemicalStack)object;
                yield var3_6 = new ChemicalStackIngredient((ChemicalIngredient)new SingleChemicalIngredient(c.getChemicalHolder()), c.getAmount());
            }
            case 3 -> {
                ChemicalStackIngredient var3_7;
                Chemical c = (Chemical)object;
                yield var3_7 = new ChemicalStackIngredient((ChemicalIngredient)new SingleChemicalIngredient(c.getAsHolder()), 1000L);
            }
            default -> {
                String str = from.toString();
                try {
                    ChemicalStackIngredient var3_8;
                    yield var3_8 = MekanismChemicalWrapper.readStackIngredient(new StringReader(str));
                }
                catch (CommandSyntaxException ex) {
                    ChemicalStackIngredient var3_9;
                    ex.printStackTrace();
                    yield var3_9 = new ChemicalStackIngredient((ChemicalIngredient)EmptyChemicalIngredient.INSTANCE, 1L);
                }
            }
        };
    }

    public static ChemicalStackIngredient readStackIngredient(StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        long amount = FluidWrapper.readFluidAmount((StringReader)reader);
        reader.skipWhitespace();
        ChemicalIngredient ingredient = MekanismChemicalWrapper.readIngredient(reader);
        return new ChemicalStackIngredient(ingredient, amount);
    }
}

