/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.mekanism;

import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.providers.IChemicalProvider;
import mekanism.common.integration.LazyChemicalProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

@ReturnsSelf
public class KubeChemicalBuilder
extends BuilderBase<Chemical> {
    protected ChemicalBuilder chemicalBuilder;

    public KubeChemicalBuilder(ResourceLocation id) {
        super(id);
    }

    private ChemicalBuilder chemicalBuilder() {
        if (this.chemicalBuilder == null) {
            this.chemicalBuilder = ChemicalBuilder.builder();
        }
        return this.chemicalBuilder;
    }

    public KubeChemicalBuilder with(ChemicalAttribute attribute) {
        this.chemicalBuilder().with(attribute);
        return this;
    }

    public KubeChemicalBuilder fuel(int burnTicks, long energyDensity) {
        if (burnTicks > 0 && energyDensity > 0L) {
            return this.with((ChemicalAttribute)new ChemicalAttributes.Fuel(burnTicks, energyDensity));
        }
        return this;
    }

    public KubeChemicalBuilder heatedCoolant(ResourceLocation chemical, double thermalEnthalpy, double conductivity) {
        if (thermalEnthalpy > 0.0 && conductivity > 0.0) {
            return this.with((ChemicalAttribute)new ChemicalAttributes.HeatedCoolant((IChemicalProvider)new LazyChemicalProvider(chemical), thermalEnthalpy, conductivity));
        }
        return this;
    }

    public KubeChemicalBuilder cooledCoolant(ResourceLocation chemical, double thermalEnthalpy, double conductivity) {
        if (thermalEnthalpy > 0.0 && conductivity > 0.0) {
            return this.with((ChemicalAttribute)new ChemicalAttributes.CooledCoolant((IChemicalProvider)new LazyChemicalProvider(chemical), thermalEnthalpy, conductivity));
        }
        return this;
    }

    public KubeChemicalBuilder radiation(double radioactivity) {
        if (radioactivity > 0.0) {
            return this.with((ChemicalAttribute)new ChemicalAttributes.Radiation(radioactivity));
        }
        return this;
    }

    public KubeChemicalBuilder tint(KubeColor tint) {
        this.chemicalBuilder().tint(tint.kjs$getRGB());
        return this;
    }

    public KubeChemicalBuilder ore(TagKey<Item> oreTag) {
        this.chemicalBuilder().ore(oreTag);
        return this;
    }

    public KubeChemicalBuilder gaseous() {
        this.chemicalBuilder().gaseous();
        return this;
    }

    public Chemical createObject() {
        return new Chemical(this.chemicalBuilder());
    }

    public static class Pigment
    extends KubeChemicalBuilder {
        public Pigment(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.pigment();
        }
    }

    public static class InfuseType
    extends KubeChemicalBuilder {
        public InfuseType(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.infuseType();
        }
    }

    public static class DirtySlurry
    extends KubeChemicalBuilder {
        public DirtySlurry(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.dirtySlurry();
        }
    }

    public static class CleanSlurry
    extends KubeChemicalBuilder {
        public CleanSlurry(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.cleanSlurry();
        }
    }

    public static class Liquid
    extends KubeChemicalBuilder {
        public Liquid(ResourceLocation id) {
            super(id);
            this.chemicalBuilder = ChemicalBuilder.builder();
        }
    }

    @ReturnsSelf
    public static class Default
    extends KubeChemicalBuilder {
        public Default(ResourceLocation id) {
            super(id);
        }

        public Default texture(ResourceLocation texture) {
            this.chemicalBuilder = ChemicalBuilder.builder((ResourceLocation)texture);
            return this;
        }
    }
}

