/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material.impl;

import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class LapisLazuliMaterialDefaults
implements BaseMekanismMaterial {
    @Override
    public int getShieldDurability() {
        return 224;
    }

    @Override
    public float getAxeDamage() {
        return 4.0f;
    }

    @Override
    public float getAxeAtkSpeed() {
        return -2.9f;
    }

    public int getUses() {
        return 128;
    }

    public float getSpeed() {
        return 9.0f;
    }

    public float getAttackDamageBonus() {
        return 1.0f;
    }

    public int getEnchantmentValue() {
        return 32;
    }

    @Override
    public float toughness() {
        return 0.0f;
    }

    @Override
    public int getDurabilityForType(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.BOOTS -> 130;
            case ArmorItem.Type.LEGGINGS -> 150;
            case ArmorItem.Type.CHESTPLATE, ArmorItem.Type.BODY -> 160;
            case ArmorItem.Type.HELMET -> 110;
        };
    }

    @Override
    public int getDefense(@NotNull ArmorItem.Type armorType) {
        return switch (armorType) {
            case ArmorItem.Type.BOOTS, ArmorItem.Type.HELMET -> 1;
            case ArmorItem.Type.LEGGINGS -> 3;
            case ArmorItem.Type.CHESTPLATE -> 4;
            default -> 0;
        };
    }

    @Override
    @NotNull
    public String getRegistryPrefix() {
        return "lapis_lazuli";
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return ToolsTags.Blocks.INCORRECT_FOR_LAPIS_LAZULI_TOOL;
    }

    @Override
    @NotNull
    public Holder<SoundEvent> equipSound() {
        return SoundEvents.ARMOR_EQUIP_DIAMOND;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return Ingredient.of((TagKey)Tags.Items.GEMS_LAPIS);
    }

    @Override
    public float knockbackResistance() {
        return 0.0f;
    }
}

