/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import mekanism.api.providers.IItemProvider;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.tools.common.config.MekanismToolsConfig;
import mekanism.tools.common.config.ToolsConfig;
import mekanism.tools.common.registries.ToolsItems;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;

public class MobEquipmentHelper {
    private static final GearType REFINED_GLOWSTONE = new GearType((IItemProvider)ToolsItems.REFINED_GLOWSTONE_SWORD, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_SHOVEL, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_HELMET, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_CHESTPLATE, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_LEGGINGS, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_BOOTS, MekanismToolsConfig.tools.refinedGlowstoneSpawnRate);
    private static final GearType LAPIS_LAZULI = new GearType((IItemProvider)ToolsItems.LAPIS_LAZULI_SWORD, (IItemProvider)ToolsItems.LAPIS_LAZULI_SHOVEL, (IItemProvider)ToolsItems.LAPIS_LAZULI_HELMET, (IItemProvider)ToolsItems.LAPIS_LAZULI_CHESTPLATE, (IItemProvider)ToolsItems.LAPIS_LAZULI_LEGGINGS, (IItemProvider)ToolsItems.LAPIS_LAZULI_BOOTS, MekanismToolsConfig.tools.lapisLazuliSpawnRate);
    private static final GearType REFINED_OBSIDIAN = new GearType((IItemProvider)ToolsItems.REFINED_OBSIDIAN_SWORD, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_SHOVEL, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_HELMET, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_CHESTPLATE, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_LEGGINGS, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_BOOTS, MekanismToolsConfig.tools.refinedObsidianSpawnRate);
    private static final GearType STEEL = new GearType((IItemProvider)ToolsItems.STEEL_SWORD, (IItemProvider)ToolsItems.STEEL_SHOVEL, (IItemProvider)ToolsItems.STEEL_HELMET, (IItemProvider)ToolsItems.STEEL_CHESTPLATE, (IItemProvider)ToolsItems.STEEL_LEGGINGS, (IItemProvider)ToolsItems.STEEL_BOOTS, MekanismToolsConfig.tools.steelSpawnRate);
    private static final GearType BRONZE = new GearType((IItemProvider)ToolsItems.BRONZE_SWORD, (IItemProvider)ToolsItems.BRONZE_SHOVEL, (IItemProvider)ToolsItems.BRONZE_HELMET, (IItemProvider)ToolsItems.BRONZE_CHESTPLATE, (IItemProvider)ToolsItems.BRONZE_LEGGINGS, (IItemProvider)ToolsItems.BRONZE_BOOTS, MekanismToolsConfig.tools.bronzeSpawnRate);
    private static final GearType OSMIUM = new GearType((IItemProvider)ToolsItems.OSMIUM_SWORD, (IItemProvider)ToolsItems.OSMIUM_SHOVEL, (IItemProvider)ToolsItems.OSMIUM_HELMET, (IItemProvider)ToolsItems.OSMIUM_CHESTPLATE, (IItemProvider)ToolsItems.OSMIUM_LEGGINGS, (IItemProvider)ToolsItems.OSMIUM_BOOTS, MekanismToolsConfig.tools.osmiumSpawnRate);

    private static boolean isZombie(LivingEntity entity) {
        return entity instanceof Zombie && !(entity instanceof Drowned) && !(entity instanceof ZombifiedPiglin);
    }

    public static void onLivingSpecialSpawn(FinalizeSpawnEvent event) {
        Mob entity = event.getEntity();
        boolean isZombie = MobEquipmentHelper.isZombie((LivingEntity)entity);
        if (isZombie || entity instanceof Skeleton || entity instanceof Stray || entity instanceof Piglin) {
            RandomSource random = event.getLevel().getRandom();
            DifficultyInstance difficulty = event.getDifficulty();
            boolean isHard = difficulty.getDifficulty() == Difficulty.HARD;
            float difficultyMultiplier = difficulty.getSpecialMultiplier();
            GearType gearType = null;
            if (random.nextFloat() < MekanismToolsConfig.tools.armorSpawnChance.get() * difficultyMultiplier) {
                gearType = MobEquipmentHelper.getGearType(entity instanceof Piglin ? 0 : random.nextInt(6));
                MobEquipmentHelper.setEntityArmorWithChance(random, (LivingEntity)entity, isHard, difficulty, gearType);
            }
            if (isZombie) {
                CachedFloatValue spawnChance;
                CachedFloatValue cachedFloatValue = spawnChance = isHard ? MekanismToolsConfig.tools.weaponSpawnChanceHard : MekanismToolsConfig.tools.weaponSpawnChance;
                if (random.nextFloat() < spawnChance.get()) {
                    if (gearType == null) {
                        gearType = MobEquipmentHelper.getGearType(random.nextInt(6));
                    }
                    if (gearType.spawnChance.canSpawnWeapon.get()) {
                        IItemProvider weapon = random.nextFloat() < gearType.spawnChance.swordWeight.get() ? gearType.sword : gearType.shovel;
                        MobEquipmentHelper.setStackIfEmpty((LivingEntity)entity, random, gearType.spawnChance.weaponEnchantmentChance.get(), difficulty, EquipmentSlot.MAINHAND, weapon);
                    }
                }
            }
        }
    }

    private static GearType getGearType(int type) {
        return switch (type) {
            default -> REFINED_GLOWSTONE;
            case 1 -> LAPIS_LAZULI;
            case 2 -> REFINED_OBSIDIAN;
            case 3 -> STEEL;
            case 4 -> BRONZE;
            case 5 -> OSMIUM;
        };
    }

    private static void setEntityArmorWithChance(RandomSource random, LivingEntity entity, boolean isHard, DifficultyInstance difficulty, GearType gearType) {
        float stopChance;
        ToolsConfig.ArmorSpawnChanceConfig chanceConfig = gearType.spawnChance();
        float f = stopChance = isHard ? chanceConfig.multiplePieceChanceHard.get() : chanceConfig.multiplePieceChance.get();
        if (random.nextFloat() < chanceConfig.bootsChance.get()) {
            MobEquipmentHelper.setStackIfEmpty(entity, random, chanceConfig.armorEnchantmentChance.get(), difficulty, EquipmentSlot.FEET, gearType.boots);
            if (random.nextFloat() < stopChance) {
                return;
            }
        }
        if (random.nextFloat() < chanceConfig.leggingsChance.get()) {
            MobEquipmentHelper.setStackIfEmpty(entity, random, chanceConfig.armorEnchantmentChance.get(), difficulty, EquipmentSlot.LEGS, gearType.leggings);
            if (random.nextFloat() < stopChance) {
                return;
            }
        }
        if (random.nextFloat() < chanceConfig.chestplateChance.get()) {
            MobEquipmentHelper.setStackIfEmpty(entity, random, chanceConfig.armorEnchantmentChance.get(), difficulty, EquipmentSlot.CHEST, gearType.chestplate);
            if (random.nextFloat() < stopChance) {
                return;
            }
        }
        if (random.nextFloat() < chanceConfig.helmetChance.get()) {
            MobEquipmentHelper.setStackIfEmpty(entity, random, chanceConfig.armorEnchantmentChance.get(), difficulty, EquipmentSlot.HEAD, gearType.helmet);
        }
    }

    private static void setStackIfEmpty(LivingEntity entity, RandomSource random, float baseChance, DifficultyInstance difficulty, EquipmentSlot slot, IItemProvider item) {
        if (entity.getItemBySlot(slot).isEmpty()) {
            ItemStack stack = item.getItemStack();
            if (random.nextFloat() < baseChance * difficulty.getSpecialMultiplier()) {
                EnchantmentHelper.enchantItemFromProvider((ItemStack)stack, (RegistryAccess)entity.level().registryAccess(), (ResourceKey)VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, (DifficultyInstance)difficulty, (RandomSource)random);
            }
            entity.setItemSlot(slot, stack);
        }
    }

    private record GearType(IItemProvider sword, IItemProvider shovel, IItemProvider helmet, IItemProvider chestplate, IItemProvider leggings, IItemProvider boots, ToolsConfig.ArmorSpawnChanceConfig spawnChance) {
    }
}

