/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.raytracer.VoxelShapeBlockHitResult;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class IndexedVoxelShape
extends VoxelShape {
    private final VoxelShape parent;
    private final Object data;

    public IndexedVoxelShape(VoxelShape parent, Object data) {
        super(parent.shape);
        this.parent = parent;
        this.data = data;
    }

    public DoubleList getCoords(Direction.Axis axis) {
        return this.parent.getCoords(axis);
    }

    @Nullable
    public VoxelShapeBlockHitResult clip(Vec3 start, Vec3 end, BlockPos pos) {
        BlockHitResult result = this.parent.clip(start, end, pos);
        if (result == null) {
            return null;
        }
        double dist = result.getLocation().distanceToSqr(start);
        return new VoxelShapeBlockHitResult(result, this, dist);
    }

    public Object getData() {
        return this.data;
    }
}

