/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface ColourState {
    public int get();

    default public ColourARGB getColour() {
        return new ColourARGB(this.get());
    }

    public void set(int var1);

    default public void set(Colour colour) {
        this.set(colour.argb());
    }

    default public String getHexColour() {
        return Integer.toHexString(this.get()).toUpperCase(Locale.ROOT);
    }

    default public void setHexColour(String hexColour) {
        try {
            this.set(Integer.parseUnsignedInt(hexColour, 16));
        }
        catch (Throwable e) {
            this.set(0);
        }
    }

    public static ColourState create() {
        return ColourState.create(null);
    }

    public static ColourState create(final Consumer<Integer> listener) {
        return new ColourState(){
            int colour = 0;

            @Override
            public int get() {
                return this.colour;
            }

            @Override
            public void set(int colour) {
                this.colour = colour;
                if (listener != null) {
                    listener.accept(colour);
                }
            }
        };
    }

    public static ColourState create(final Supplier<Integer> getter, final Consumer<Integer> setter) {
        return new ColourState(){

            @Override
            public int get() {
                return (Integer)getter.get();
            }

            @Override
            public void set(int colour) {
                setter.accept(colour);
            }
        };
    }
}

