/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block;

import codechicken.lib.block.ModularTileBlock;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

@ApiStatus.Experimental
public abstract class ModularBlockEntity
extends BlockEntity {
    private final ModularTileBlock<?> block;
    private final DataComponent[] components;

    public ModularBlockEntity(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
        Block bl = state.getBlock();
        if (!(bl instanceof ModularTileBlock)) {
            throw new IllegalStateException("ModularBlockEntity constructed with the incorrect Block! Expected a ModularTileBlock. Got: " + bl.getClass().getName() + " State: " + String.valueOf(state));
        }
        this.block = (ModularTileBlock)bl;
        this.components = new DataComponent[this.block.namedComponents.size()];
        for (ModularTileBlock.TileComponent<?> component : this.block.namedComponents.values()) {
            this.components[component.id] = component.createData(this);
        }
    }

    public final <T extends DataComponent> T getData(ModularTileBlock.TileComponent<T> component) {
        assert (this.block.namedComponents.get(component.name) == component);
        return (T)((DataComponent)SneakyUtils.unsafeCast(this.components[component.id]));
    }

    @MustBeInvokedByOverriders
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        for (DataComponent component : this.components) {
            CompoundTag componentTag = new CompoundTag();
            component.save(componentTag, registries);
            tag.put(component.tileComponent.name, (Tag)componentTag);
        }
    }

    @MustBeInvokedByOverriders
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        for (DataComponent component : this.components) {
            if (!tag.contains(component.tileComponent.name)) continue;
            component.load(tag.getCompound(component.tileComponent.name), registries);
        }
    }

    public static abstract class DataComponent {
        protected final ModularBlockEntity tile;
        protected final ModularTileBlock.TileComponent<?> tileComponent;

        protected DataComponent(ModularBlockEntity tile, ModularTileBlock.TileComponent<?> tileComponent) {
            this.tile = tile;
            this.tileComponent = tileComponent;
        }

        protected void save(CompoundTag tag, HolderLookup.Provider registries) {
        }

        protected void load(CompoundTag tag, HolderLookup.Provider registries) {
        }
    }
}

