/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class RegistryExportableDryingBasinRecipe
extends RegistryExportableRecipeAbstract<RecipeType<RecipeDryingBasin>, RecipeDryingBasin, IInventoryFluid> {
    protected RegistryExportableDryingBasinRecipe() {
        super(() -> RegistryEntries.RECIPETYPE_DRYING_BASIN.get());
    }

    public static JsonObject serializeRecipeStatic(RecipeDryingBasin recipe) {
        JsonObject object = new JsonObject();
        int duration = recipe.getDuration();
        object.addProperty("duration", (Number)duration);
        JsonObject inputObject = new JsonObject();
        ItemStack[] inputItems = recipe.getInputIngredient().map(Ingredient::getItems).orElse(new ItemStack[0]);
        JsonArray arrayInputs = new JsonArray();
        for (ItemStack input : inputItems) {
            arrayInputs.add((JsonElement)IRegistryExportable.serializeItemStack((ItemStack)input));
        }
        inputObject.add("item", (JsonElement)arrayInputs);
        Optional<FluidStack> inputFluid = recipe.getInputFluid();
        inputFluid.ifPresent(fluidStack -> inputObject.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)fluidStack)));
        JsonObject outputObject = new JsonObject();
        Optional<FluidStack> fluidOutput = recipe.getOutputFluid();
        fluidOutput.ifPresent(fluidStack -> outputObject.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)fluidStack)));
        ItemStack itemOutput = recipe.getOutputItemFirst();
        outputObject.add("item", (JsonElement)IRegistryExportable.serializeItemStack((ItemStack)itemOutput));
        object.add("input", (JsonElement)inputObject);
        object.add("output", (JsonElement)outputObject);
        return object;
    }

    public JsonObject serializeRecipe(RecipeHolder<RecipeDryingBasin> recipe) {
        return RegistryExportableDryingBasinRecipe.serializeRecipeStatic((RecipeDryingBasin)recipe.value());
    }
}

