/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntryListener;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeDropdownList;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeStringValueChangedPacket;

@OnlyIn(value=Dist.CLIENT)
public class GuiElementValueTypeDropdownListRenderPattern<T, S extends ISubGuiBox, G extends Screen, C extends AbstractContainerMenu>
extends RenderPattern<GuiElementValueTypeDropdownList<T, G, C>, G, C>
implements IDropdownEntryListener<T> {
    protected final GuiElementValueTypeDropdownList<T, G, C> element;
    private WidgetTextFieldDropdown<T> searchField = null;

    public GuiElementValueTypeDropdownListRenderPattern(GuiElementValueTypeDropdownList<T, G, C> element, int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        this.element = element;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        Font fontRenderer = Minecraft.getInstance().font;
        int searchWidth = ((GuiElementValueTypeDropdownList)this.getElement()).getRenderPattern().getWidth() - 28;
        int searchX = this.getX() + 14;
        int searchY = this.getY() + 6;
        Objects.requireNonNull(fontRenderer);
        this.searchField = new WidgetTextFieldDropdown<T>(fontRenderer, guiLeft + searchX, guiTop + searchY, searchWidth, 9 + 3, (Component)Component.translatable((String)"gui.cyclopscore.search"), true, this.getDropdownPossibilities());
        this.searchField.setDropdownEntryListener(this);
        this.searchField.setMaxLength(64);
        this.searchField.setBordered(false);
        this.searchField.setVisible(true);
        this.searchField.setTextColor(0xFFFFFF);
        this.searchField.setCanLoseFocus(true);
        String value = this.element.getInputString();
        if (value == null) {
            value = "";
        }
        this.searchField.setValue(value);
        this.element.setInputString(this.searchField.getValue());
        this.searchField.setWidth(searchWidth);
        this.searchField.setX(guiLeft + (searchX + searchWidth) - this.searchField.getWidth());
    }

    protected Set<IDropdownEntry<T>> getDropdownPossibilities() {
        return this.element.getDropdownPossibilities();
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        this.searchField.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (this.searchField.isFocused() && this.searchField.charTyped(typedChar, keyCode)) {
            this.onTyped();
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    @Override
    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (this.searchField.isFocused()) {
            this.searchField.keyPressed(typedChar, keyCode, modifiers);
            this.onTyped();
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    private void onTyped() {
        this.element.setInputString(this.searchField.getValue());
        if (this.container instanceof IDirtyMarkListener) {
            ((IDirtyMarkListener)this.container).onDirty();
        }
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeStringValueChangedPacket(this.element.getInputString()));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.searchField.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void onSetDropdownPossiblity(IDropdownEntry dropdownEntry) {
        this.element.onSetDropdownPossiblity(dropdownEntry);
        if (this.container instanceof IDirtyMarkListener) {
            ((IDirtyMarkListener)this.container).onDirty();
        }
    }

    @Override
    public GuiElementValueTypeDropdownList<T, G, C> getElement() {
        return this.element;
    }

    public WidgetTextFieldDropdown<T> getSearchField() {
        return this.searchField;
    }
}

