/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.util.BlockStateUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PlateBlock
extends Block {
    public static final DirectionProperty ATTACHMENT_DIRECTION = PlateBlockStateProperties.ATTACHMENT_DIRECTION;
    public static final IntegerProperty ROTATION = PlateBlockStateProperties.ROTATION;
    public static final VoxelShape[] SHAPES_BY_DIRECTION = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public PlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState baseState = (BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ATTACHMENT_DIRECTION, (Comparable)Direction.DOWN)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0));
        this.registerDefaultState(baseState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ATTACHMENT_DIRECTION, ROTATION});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return PlateBlockStateProperties.getStateForPlacedGatePlate(this.defaultBlockState(), context);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.hasProperty((Property)ATTACHMENT_DIRECTION)) {
            return SHAPES_BY_DIRECTION[((Direction)state.getValue((Property)ATTACHMENT_DIRECTION)).ordinal()];
        }
        return SHAPES_BY_DIRECTION[0];
    }

    @Deprecated
    public BlockState rotate(BlockState state, Rotation rotation) {
        if (state.hasProperty((Property)ATTACHMENT_DIRECTION) && state.hasProperty((Property)ROTATION)) {
            Direction attachmentDirection = (Direction)state.getValue((Property)ATTACHMENT_DIRECTION);
            int rotationIndex = (Integer)state.getValue((Property)ROTATION);
            Direction newAttachmentDirection = rotation.rotate(attachmentDirection);
            int newRotationIndex = BlockStateUtil.getRotatedRotation(attachmentDirection, rotationIndex, rotation);
            return (BlockState)((BlockState)state.setValue((Property)ATTACHMENT_DIRECTION, (Comparable)newAttachmentDirection)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
        }
        return state;
    }

    @Deprecated
    public BlockState mirror(BlockState state, Mirror mirror) {
        if (state.hasProperty((Property)ATTACHMENT_DIRECTION) && state.hasProperty((Property)ROTATION)) {
            Direction attachmentDirection = (Direction)state.getValue((Property)ATTACHMENT_DIRECTION);
            int rotationIndex = (Integer)state.getValue((Property)ROTATION);
            Direction newAttachmentDirection = mirror.mirror(attachmentDirection);
            int newRotationIndex = BlockStateUtil.getMirroredRotation(attachmentDirection, rotationIndex, mirror);
            return (BlockState)((BlockState)state.setValue((Property)ATTACHMENT_DIRECTION, (Comparable)newAttachmentDirection)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
        }
        return state;
    }
}

