/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen.widgets;

import com.direwolf20.buildinggadgets2.client.OurSounds;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;

public class IncrementalSliderWidget
extends ExtendedSlider {
    private static final int BACKGROUND = IncrementalSliderWidget.createAlphaColor(Color.DARK_GRAY, 200).getRGB();
    private static final int SLIDER_BACKGROUND = IncrementalSliderWidget.createAlphaColor(Color.DARK_GRAY.darker(), 200).getRGB();
    private static final int SLIDER_COLOR = IncrementalSliderWidget.createAlphaColor(Color.DARK_GRAY.brighter().brighter(), 200).getRGB();
    public final Consumer<IncrementalSliderWidget> onUpdate;

    public IncrementalSliderWidget(int x, int y, int width, int height, double min, double max, Component prefix, double current, Consumer<IncrementalSliderWidget> onUpdate) {
        super(x, y, width, height, prefix, (Component)Component.empty(), min, max, current, 1.0, 1, true);
        this.onUpdate = onUpdate;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, BACKGROUND);
        this.drawBorderedRect(guiGraphics, this.getX() + (int)(this.value * (double)(this.width - 8)) + 4 - 4, this.getY(), 8, this.height);
        this.renderText(guiGraphics);
    }

    private void renderText(GuiGraphics guiGraphics) {
        int color = !this.active ? 0xA0A0A0 : (this.isHovered ? 0xFFFFA0 : -1);
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.drawCenteredString(minecraft.font, (Component)this.prefix.copy().append(this.getValueString()), this.getX() + this.getWidth() / 2, this.getY() + (this.getHeight() - 8) / 2, color);
    }

    private void drawBorderedRect(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        guiGraphics.fill(x, y, x + width, y + height, SLIDER_BACKGROUND);
        guiGraphics.fill(++x, ++y, x + width - 2, y + height - 2, SLIDER_COLOR);
    }

    protected void applyValue() {
        this.onUpdate.accept(this);
    }

    public void onRelease(double p_93609_, double p_93610_) {
    }

    public void playDownSound(SoundManager p_93605_) {
    }

    public boolean mouseReleased(double p_93684_, double p_93685_, int p_93686_) {
        boolean result = super.mouseReleased(p_93684_, p_93685_, p_93686_);
        if (result) {
            OurSounds.playSound(Registration.BEEP.get());
        }
        return result;
    }

    private static Color createAlphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public Collection<AbstractWidget> getComponents() {
        return ImmutableSet.of((Object)((Object)this), (Object)((Object)new GuiButtonIncrement(this.getX() - this.height - 5, this.getY(), this.height, this.height, (Component)Component.literal((String)"-"), b -> {
            this.setValue(this.getValueInt() - 1);
            this.applyValue();
        })), (Object)((Object)new GuiButtonIncrement(this.getX() + this.width + 5, this.getY(), this.height, this.height, (Component)Component.literal((String)"+"), b -> {
            this.setValue(this.getValueInt() + 1);
            this.applyValue();
        })));
    }

    private class GuiButtonIncrement
    extends Button {
        public GuiButtonIncrement(int x, int y, int width, int height, Component message, Button.OnPress action) {
            super(x, y, width, height, message, action, Button.DEFAULT_NARRATION);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
            if (!this.visible) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, BACKGROUND);
            IncrementalSliderWidget.this.drawBorderedRect(guiGraphics, this.getX(), this.getY(), this.width, this.height);
            guiGraphics.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, this.getFGColor() | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }

        public void onRelease(double p_93609_, double p_93610_) {
        }

        public void playDownSound(SoundManager soundManager) {
            OurSounds.playSound(Registration.BEEP.get());
        }
    }
}

