/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.items.tools;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.container.VigorBowContainer;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.util.HealthModifier;
import com.traverse.bhc.common.util.SoulContainerProvider;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class ItemVigorBow
extends BowItem
implements SoulContainerProvider {
    public static final ResourceLocation DAMAGE_MODIFIER_ID = BaubleyHeartCanisters.id("vigor_bow");
    private static final double EXTRA_DAMAGE_PER_HEART = 1.0;

    public ItemVigorBow() {
        super(new Item.Properties());
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        arrow.setBaseDamage(arrow.getBaseDamage() + (double)(HealthModifier.getHeartCount(weaponStack) / 2));
        return arrow;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Level level = entity.level();
        Player player = (Player)entity;
        if (entity.isShiftKeyDown() && !level.isClientSide()) {
            this.openMenu(player, hand, VigorBowContainer::new);
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack itemstack = player.getProjectile(stack);
            int i = (this.getUseDuration(stack, entity) - timeLeft) * Math.max(HealthModifier.getHeartCount(stack) / 2, 1);
            if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
                return;
            }
            float f = ItemVigorBow.getPowerForTime((int)i);
            if (!((double)f < 0.1)) {
                List list = ItemVigorBow.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    if (!list.isEmpty()) {
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * 3.0f, 1.0f / (float)Math.max(HealthModifier.getHeartCount(stack) / 2, 1), f == 1.0f, null);
                    }
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    @Override
    public Component getContainerName(ItemStack stack) {
        return Component.translatable((String)"container.bhc.vigor_bow");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)RegistryHandler.VIGOR_BOW.getId())).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GOLD)));
        if (HealthModifier.getHeartCount(stack) > 0) {
            tooltipComponents.add((Component)Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)BaubleyHeartCanisters.id("bonus")), (Object[])new Object[]{HealthModifier.getHeartCount(stack)}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
        }
        if (Screen.hasShiftDown()) {
            int[] heartCount = new int[]{HealthModifier.getHeartCount(stack)};
            int heartTotal = IntStream.of(heartCount).sum();
            tooltipComponents.add((Component)Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)BaubleyHeartCanisters.id("heart_amount")), (Object[])new Object[]{heartTotal}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.DARK_RED)));
        }
    }
}

