/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.items;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.container.HeartAmuletContainer;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.items.BaseItem;
import com.traverse.bhc.common.util.HealthModifier;
import com.traverse.bhc.common.util.SoulContainerProvider;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ItemHeartAmulet
extends BaseItem
implements SoulContainerProvider,
ICurioItem {
    public ItemHeartAmulet() {
        super(1);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!level.isClientSide()) {
                this.openMenu(player, hand, HeartAmuletContainer::new);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)RegistryHandler.HEART_AMULET.getId())).withStyle(ChatFormatting.GOLD));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (Screen.hasShiftDown()) {
            int[] heartCount = new int[]{HealthModifier.getHeartCount(stack)};
            int heartTotal = IntStream.of(heartCount).sum();
            tooltipComponents.add((Component)Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)BaubleyHeartCanisters.id("heart_amount")), (Object[])new Object[]{heartTotal}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.DARK_RED)));
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ICuriosItemHandler handler = CuriosApi.getCuriosInventory((LivingEntity)livingEntity).orElse(null);
            if (handler == null) {
                return;
            }
            SlotResult equipped = handler.findFirstCurio((Item)RegistryHandler.HEART_AMULET.get()).orElse(null);
            if (equipped != null) {
                HealthModifier.updatePlayerHealth(player, equipped.stack(), true);
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            HealthModifier.updatePlayerHealth(player, ItemStack.EMPTY, false);
        }
    }

    @Override
    public Component getContainerName(ItemStack stack) {
        return Component.translatable((String)Util.makeDescriptionId((String)"container", (ResourceLocation)RegistryHandler.HEART_AMUlET_CONTAINER.getId()));
    }
}

