/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.bookstate.BookStatesSaveData;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStates;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.networking.Message;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncBookVisualStatesMessage
implements Message {
    public static final CustomPacketPayload.Type<SyncBookVisualStatesMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"modonomicon", (String)"sync_book_visual_states"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncBookVisualStatesMessage> STREAM_CODEC = StreamCodec.composite(BookVisualStates.STREAM_CODEC, m -> m.states, SyncBookVisualStatesMessage::new);
    public BookVisualStates states;

    public SyncBookVisualStatesMessage(BookVisualStates states) {
        this.states = states;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        if (minecraft.getSingleplayerServer() == null) {
            BookVisualStateManager.get().saveData = new BookStatesSaveData((Map<UUID, BookUnlockStates>)Object2ObjectMaps.emptyMap(), Map.of(player.getUUID(), this.states));
        }
        if (BookGuiManager.get().openBookEntryScreen != null) {
            BookGuiManager.get().openBookEntryScreen.onSyncBookVisualStatesMessage(this);
        }
    }
}

