/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.command;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ResetBookUnlocksCommand
implements Command<CommandSourceStack> {
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_BOOK = new DynamicCommandExceptionType(message -> Component.translatable((String)"modonomicon.command.error.unknown_book", (Object[])new Object[]{message}));
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_BOOK = (context, builder) -> {
        List<ResourceLocation> books = BookUnlockStateManager.get().getBooksFor((Player)((CommandSourceStack)context.getSource()).getPlayer());
        return SharedSuggestionProvider.suggestResource(books, (SuggestionsBuilder)builder);
    };
    private static final ResetBookUnlocksCommand CMD = new ResetBookUnlocksCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"book", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_BOOK).executes((Command)CMD));
    }

    public static Book getBook(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocationArgument.getId(pContext, (String)pName);
        Book book = BookDataManager.get().getBook(resourcelocation);
        if (book == null) {
            throw ERROR_UNKNOWN_BOOK.create((Object)resourcelocation);
        }
        return book;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Book book = ResetBookUnlocksCommand.getBook(context, "book");
        BookUnlockStateManager.get().resetFor(((CommandSourceStack)context.getSource()).getPlayer(), book);
        BookUnlockStateManager.get().updateAndSyncFor(((CommandSourceStack)context.getSource()).getPlayer());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"modonomicon.command.success.reset_book", (Object[])new Object[]{Component.translatable((String)book.getName())}), true);
        return 1;
    }
}

