/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.StringUtil;

public abstract class CategoryProvider
extends CategoryProviderBase {
    protected CategoryEntryMap entryMap = new CategoryEntryMap();
    protected BookCategoryModel category = null;
    protected int currentSortIndex = 0;

    public CategoryProvider(ModonomiconProviderBase parent) {
        super(parent, parent.modId(), parent.lang(), parent.langsAsMapOfBiConsumers(), parent.context(), parent.condition());
    }

    @Override
    public CategoryEntryMap entryMap() {
        return this.entryMap;
    }

    @Override
    protected Map<String, String> macros() {
        return Stream.concat(super.macros().entrySet().stream(), this.parent.macros().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
    }

    protected BookEntryParentModel parent(BookEntryModel parentEntry) {
        return BookEntryParentModel.create(parentEntry.getId());
    }

    @Override
    public BookEntryModel add(BookEntryModel entry) {
        if (entry.getSortNumber() == -1) {
            entry.withSortNumber(this.currentSortIndex++);
        }
        this.category.withEntry(entry);
        return entry;
    }

    @Override
    public List<BookEntryModel> add(List<BookEntryModel> entries) {
        for (BookEntryModel entry : entries) {
            if (entry.getSortNumber() != -1) continue;
            entry.withSortNumber(this.currentSortIndex++);
        }
        this.category.withEntries(entries);
        return entries;
    }

    public BookCategoryModel generate() {
        this.context().category(this.categoryId());
        String[] map = this.generateEntryMap();
        if (map != null && map.length > 0) {
            this.entryMap().setMap(this.generateEntryMap());
        }
        BookCategoryModel category = BookCategoryModel.create(this.modLoc(this.context().categoryId()), this.context().categoryName());
        this.add(this.context().categoryName(), this.categoryName());
        String categoryDescription = this.categoryDescription();
        if (!StringUtil.isNullOrEmpty((String)categoryDescription)) {
            this.add(this.context().categoryDescription(), categoryDescription);
            category.withDescription(this.context().categoryDescription());
        }
        category.withIcon(this.categoryIcon());
        this.category = this.additionalSetup(category);
        this.generateEntries();
        return this.category;
    }

    protected abstract String[] generateEntryMap();

    protected abstract void generateEntries();

    protected BookCategoryModel additionalSetup(BookCategoryModel category) {
        return category;
    }

    protected abstract String categoryName();

    protected String categoryDescription() {
        return "";
    }

    protected abstract BookIconModel categoryIcon();

    @Override
    public abstract String categoryId();
}

