/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.gson.JsonElement;
import com.klikli_dev.modonomicon.api.datagen.BookSubProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BookProvider
implements DataProvider {
    protected final String modId;
    protected final CompletableFuture<HolderLookup.Provider> registries;
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, BookModel> bookModels;
    protected final List<BookSubProvider> subProviders;

    public BookProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, String modId, List<BookSubProvider> subProviders) {
        this.packOutput = packOutput;
        this.registries = registries;
        this.modId = modId;
        this.subProviders = subProviders;
        this.bookModels = new Object2ObjectOpenHashMap();
    }

    public String modId() {
        return this.modId;
    }

    protected Path getPath(Path dataFolder, BookModel bookModel) {
        ResourceLocation id = bookModel.getId();
        return dataFolder.resolve(id.getNamespace()).resolve("modonomicon/books").resolve(id.getPath() + "/book.json");
    }

    protected Path getPath(Path dataFolder, BookCategoryModel bookCategoryModel) {
        ResourceLocation id = bookCategoryModel.getId();
        return dataFolder.resolve(id.getNamespace()).resolve("modonomicon/books").resolve(bookCategoryModel.getBook().getId().getPath()).resolve("categories").resolve(id.getPath() + ".json");
    }

    protected Path getPath(Path dataFolder, BookCommandModel bookCommandModel) {
        ResourceLocation id = bookCommandModel.getId();
        return dataFolder.resolve(id.getNamespace()).resolve("modonomicon/books").resolve(bookCommandModel.getBook().getId().getPath()).resolve("commands").resolve(id.getPath() + ".json");
    }

    protected Path getPath(Path dataFolder, BookEntryModel bookEntryModel) {
        ResourceLocation id = bookEntryModel.getId();
        return dataFolder.resolve(id.getNamespace()).resolve("modonomicon/books").resolve(bookEntryModel.getCategory().getBook().getId().getPath()).resolve("entries").resolve(id.getPath() + ".json");
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return this.registries.thenCompose(registries -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            Path dataFolder = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK);
            this.subProviders.forEach(subProvider -> subProvider.generate(this.bookModels::put, (HolderLookup.Provider)registries));
            for (BookModel bookModel : this.bookModels.values()) {
                Path bookPath = this.getPath(dataFolder, bookModel);
                futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)bookModel.toJson((HolderLookup.Provider)registries), (Path)bookPath));
                for (BookCategoryModel bookCategoryModel : bookModel.getCategories()) {
                    Path bookCategoryPath = this.getPath(dataFolder, bookCategoryModel);
                    futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)bookCategoryModel.toJson((HolderLookup.Provider)registries), (Path)bookCategoryPath));
                    for (BookEntryModel bookEntryModel : bookCategoryModel.getEntries()) {
                        Path bookEntryPath = this.getPath(dataFolder, bookEntryModel);
                        futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)bookEntryModel.toJson((HolderLookup.Provider)registries), (Path)bookEntryPath));
                    }
                }
                for (BookCommandModel bookCommandModel : bookModel.getCommands()) {
                    Path bookCommandPath = this.getPath(dataFolder, bookCommandModel);
                    futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)bookCommandModel.toJson((HolderLookup.Provider)registries), (Path)bookCommandPath));
                }
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    @NotNull
    public String getName() {
        return "Books: " + this.modId();
    }

    protected BookModel add(BookModel bookModel) {
        if (this.bookModels.containsKey(bookModel.getId())) {
            throw new IllegalStateException("Duplicate book " + String.valueOf(bookModel.getId()));
        }
        this.bookModels.put(bookModel.getId(), bookModel);
        return bookModel;
    }
}

