/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeaa;

import com.almostreliable.kubeaa.binding.CrushingResultBinding;
import com.almostreliable.kubeaa.binding.EffectInstanceBinding;
import com.almostreliable.kubeaa.component.CrusherResultComponent;
import com.almostreliable.kubeaa.component.EffectInstanceComponent;
import com.almostreliable.kubeaa.component.SingleItemStackComponent;
import com.almostreliable.kubeaa.event.EmpowerEvent;
import com.almostreliable.kubeaa.recipe.CrusherKubeRecipe;
import com.almostreliable.kubeaa.recipe.EmpowererKubeRecipe;
import com.almostreliable.kubeaa.recipe.FermenterKubeRecipe;
import com.almostreliable.kubeaa.recipe.LiquidFuelKubeRecipe;
import com.almostreliable.kubeaa.recipe.PressKubeRecipe;
import com.almostreliable.kubeaa.schema.CoffeeIngredientRecipeSchema;
import com.almostreliable.kubeaa.schema.ColorChangeRecipeSchema;
import com.almostreliable.kubeaa.schema.CrusherRecipeSchema;
import com.almostreliable.kubeaa.schema.EmpowererRecipeSchema;
import com.almostreliable.kubeaa.schema.FermenterRecipeSchema;
import com.almostreliable.kubeaa.schema.LaserRecipeSchema;
import com.almostreliable.kubeaa.schema.LiquidFuelRecipeSchema;
import com.almostreliable.kubeaa.schema.MiningLensRecipeSchema;
import com.almostreliable.kubeaa.schema.PressRecipeSchema;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.LaserRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.LiquidFuelRecipe;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventGroupRegistry;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactoryRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeFactoryRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaRegistry;
import dev.latvian.mods.kubejs.script.BindingRegistry;
import java.util.Map;
import net.minecraft.world.effect.MobEffects;

public class KubePlugin
implements KubeJSPlugin {
    public void registerEvents(EventGroupRegistry registry) {
        registry.register(Events.GROUP);
    }

    public void registerBindings(BindingRegistry registry) {
        if (registry.type().isServer()) {
            registry.add("CrushingResult", CrushingResultBinding.class);
            registry.add("EffectInstance", EffectInstanceBinding.class);
            registry.add("MobEffect", MobEffects.class);
        }
    }

    public void registerRecipeComponents(RecipeComponentFactoryRegistry registry) {
        registry.register(CrusherResultComponent.CRUSHING_RESULT);
        registry.register(EffectInstanceComponent.EFFECT_INSTANCE);
        registry.register((RecipeComponent)SingleItemStackComponent.STRICT_SINGLE_ITEM);
    }

    public void registerRecipeFactories(RecipeFactoryRegistry registry) {
        registry.register(CrusherKubeRecipe.FACTORY);
        registry.register(EmpowererKubeRecipe.FACTORY);
        registry.register(FermenterKubeRecipe.FACTORY);
        registry.register(LiquidFuelKubeRecipe.FACTORY);
        registry.register(PressKubeRecipe.FACTORY);
    }

    public void registerRecipeSchemas(RecipeSchemaRegistry registry) {
        Map<String, RecipeSchema> machineRecipeSchemas = Map.of(CrushingRecipe.NAME, CrusherRecipeSchema.SCHEMA, EmpowererRecipe.NAME, EmpowererRecipeSchema.SCHEMA, "fermenting", FermenterRecipeSchema.SCHEMA, LaserRecipe.NAME, LaserRecipeSchema.SCHEMA, "pressing", PressRecipeSchema.SCHEMA);
        Map<String, RecipeSchema> miscRecipeSchemas = Map.of("coffee_ingredient", CoffeeIngredientRecipeSchema.SCHEMA, "color_change", ColorChangeRecipeSchema.SCHEMA, LiquidFuelRecipe.NAME, LiquidFuelRecipeSchema.SCHEMA, "mining_lens", MiningLensRecipeSchema.SCHEMA);
        RecipeNamespace namespace = registry.namespace("actuallyadditions");
        for (Map.Entry<String, RecipeSchema> schemaEntry : machineRecipeSchemas.entrySet()) {
            namespace.register(schemaEntry.getKey(), schemaEntry.getValue());
        }
        for (Map.Entry<String, RecipeSchema> schemaEntry : miscRecipeSchemas.entrySet()) {
            namespace.register(schemaEntry.getKey(), schemaEntry.getValue());
        }
    }

    public static interface Events {
        public static final EventGroup GROUP = EventGroup.of((String)"ActuallyAdditionsEvents");
        public static final EventHandler EMPOWER = GROUP.server("empower", () -> EmpowerEvent.class);
    }
}

