/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.network;

import com.vsngarcia.Config;
import com.vsngarcia.ElevatorBlockBase;
import com.vsngarcia.level.ElevatorContainer;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public record TeleportPacket(BlockPos from, BlockPos to) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TeleportPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"elevatorid", (String)"teleport_request"));
    public static final StreamCodec<ByteBuf, TeleportPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TeleportPacket::from, (StreamCodec)BlockPos.STREAM_CODEC, TeleportPacket::to, TeleportPacket::new);

    public CustomPacketPayload.Type<TeleportPacket> type() {
        return TYPE;
    }

    public static void handle(TeleportPacket message, ServerPlayer player, SoundEvent soundEvent) {
        double toZ;
        double toX;
        float pitch;
        Level level;
        if (TeleportPacket.isBadTeleportPacket(message, (Player)player)) {
            return;
        }
        if (((Boolean)Config.GENERAL.useXP.get()).booleanValue() && !player.isCreative()) {
            Integer xpCost = (Integer)Config.GENERAL.XPPointsAmount.get();
            if (TeleportPacket.getPlayerExperienceProgress((Player)player) - xpCost >= 0 || player.experienceLevel > 0) {
                player.giveExperiencePoints(-xpCost.intValue());
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"elevatorid.message.missing_xp").withStyle(ChatFormatting.RED), true);
                return;
            }
        }
        if (!((level = player.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        BlockPos toPos = message.to();
        BlockState toState = world.getBlockState(message.to());
        float yaw = (Boolean)toState.getValue((Property)ElevatorBlockBase.DIRECTIONAL) != false ? ((Direction)toState.getValue((Property)ElevatorBlockBase.FACING)).toYRot() : player.getYRot();
        float f = pitch = (Boolean)toState.getValue((Property)ElevatorBlockBase.DIRECTIONAL) != false && (Boolean)Config.GENERAL.resetPitchDirectional.get() != false || (Boolean)toState.getValue((Property)ElevatorBlockBase.DIRECTIONAL) == false && (Boolean)Config.GENERAL.resetPitchNormal.get() != false ? 0.0f : player.getXRot();
        if (((Boolean)Config.GENERAL.precisionTarget.get()).booleanValue()) {
            toX = (double)toPos.getX() + 0.5;
            toZ = (double)toPos.getZ() + 0.5;
        } else {
            toX = player.getX();
            toZ = player.getZ();
        }
        double blockYOffset = toState.getBlockSupportShape((BlockGetter)world, toPos).max(Direction.Axis.Y);
        player.teleportTo(world, toX, Math.max((double)toPos.getY(), (double)toPos.getY() + blockYOffset), toZ, EnumSet.noneOf(RelativeMovement.class), yaw, pitch);
        player.setDeltaMovement(player.getDeltaMovement().multiply(new Vec3(1.0, 0.0, 1.0)));
        world.playSound(null, toPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static boolean isBadTeleportPacket(TeleportPacket msg, Player player) {
        if (player == null || !player.isAlive()) {
            return true;
        }
        Level world = player.level();
        BlockPos fromPos = msg.from();
        BlockPos toPos = msg.to();
        if (!world.isLoaded(fromPos) || !world.isLoaded(toPos)) {
            return true;
        }
        if (player.blockPosition().distManhattan((Vec3i)fromPos) > Config.GENERAL.activationRange.getAsInt()) {
            return true;
        }
        if (fromPos.getX() != toPos.getX() || fromPos.getZ() != toPos.getZ()) {
            return true;
        }
        if (fromPos.getY() == toPos.getY()) {
            return true;
        }
        ElevatorBlockBase fromElevator = TeleportPacket.getElevator(world.getBlockState(fromPos));
        ElevatorBlockBase toElevator = TeleportPacket.getElevator(world.getBlockState(toPos));
        if (fromElevator == null || toElevator == null) {
            return true;
        }
        if (!TeleportPacket.isValidPos((BlockGetter)world, toPos)) {
            return true;
        }
        return (Boolean)Config.GENERAL.sameColor.get() != false && fromElevator.getColor() != toElevator.getColor();
    }

    private static int getPlayerExperienceProgress(Player player) {
        return Math.round(player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static boolean isValidPos(BlockGetter world, BlockPos pos) {
        return !world.getBlockState(pos.above()).isSuffocating(world, pos.above());
    }

    public static ElevatorBlockBase getElevator(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof ElevatorBlockBase) {
            ElevatorBlockBase elevator = (ElevatorBlockBase)block;
            return elevator;
        }
        return null;
    }

    public static boolean isBadClientPacket(Player player, BlockPos pos) {
        if (player == null || player.isDeadOrDying() || player.isRemoved()) {
            return true;
        }
        Level world = player.level();
        if (!world.isLoaded(pos)) {
            return true;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof ElevatorContainer)) {
            return true;
        }
        ElevatorContainer container = (ElevatorContainer)abstractContainerMenu;
        return !container.getPos().equals((Object)pos);
    }
}

